#include "ePuck.h"

ePuck::ePuck(
		std::shared_ptr<robochart::objectSeen_channel> objectSeen,
		std::shared_ptr<robochart::goalSeen_channel> goalSeen,
		std::shared_ptr<robochart::neighbourDetected_channel> neighbourDetected):
		IObjectWatch(objectSeen), IGoalWatch(goalSeen), INeighbourWatch(neighbourDetected), IMotionControl(), INeighbourWatchOps(), IGoalWatchOps(), IObjectWatchOps() 
		{
			robot_id = 0;
		}

ePuck::~ePuck() {}


void ePuck::Sensors() {
	IMotionControl::Sensors();
	INeighbourWatchOps::Sensors();
	IGoalWatchOps::Sensors();
	IObjectWatchOps::Sensors();
	IObjectWatch::Sensors();
	IGoalWatch::Sensors();
	INeighbourWatch::Sensors();
}

void ePuck::Actuators() {
	IMotionControl::Actuators();
	INeighbourWatchOps::Actuators();
	IGoalWatchOps::Actuators();
	IObjectWatchOps::Actuators();
	IObjectWatch::Actuators();
	IGoalWatch::Actuators();
	INeighbourWatch::Actuators();
}

