
#include "State.h"

namespace robochart {

bool Transition::execute() {
	printf("test1\n");
	reg();
	printf("test2\n");
	if (condition() && check()) {  //check condition() first if it is false no need to perform check()
		auto src = source.lock();
		src->stage = State::s_Exit;
		src->execute();
		action();
		auto tgt = target.lock();
		tgt->stage = State::s_Enter;
		tgt->execute();
		return true;
	}
	return false;
}

void State::execute() {
	switch (stage) {
	case s_Enter:
		printf("Entering State %s\n", this->name.c_str());
		entry();
		if (initial() >= 0) {
			states[initial()]->stage = s_Enter;
			states[initial()]->execute();
		}
		stage = s_Execute;
		break;
	case s_Execute:
		printf("Executing a state %s\n", this->name.c_str());
		if (try_transitions() == false) {
			during();                              //if no transition is enabled, execute during action in every time step
			while(try_execute_substates(states));  //this makes sure more than one transition can happen at one cycle
		}
		break;
	case s_Exit:
		exit();
		stage = s_Inactive;
		break;
	}
}

bool State::try_transitions() {
	printf("trying %ld transitions\n", transitions.size());
	for (int i = 0; i < transitions.size(); i++) {
//		printf("transition index : %d\n", i);
		bool b = transitions[i]->execute();
		if (b) {
			cancel_transitions(i);  //erase OTHER events (in the channel) already registered by the transitions of this state, as the state tried its every possible transitions
			return true;
		}
	}
	return false;
}

void State::cancel_transitions(int i) {
	for (int j = 0; j < transitions.size(); j++) {
		if (j != i) {
			printf("CANCEL transition index: %d\n",j);
			transitions[j]->cancel();
		}
	}
}

bool State::try_execute_substates(std::vector<std::shared_ptr<State>> s) {
	for (int i = 0; i < s.size(); i++) {
		// printf("state index : %d; stage: %d\n", i, states[i]->stage);
		// there should be only one active state
		if (s[i]->stage == s_Inactive) continue;
		else {
			s[i]->execute();
			if (s[i]->stage == s_Inactive) { return true; }
			else { return false; }
		}
	}
	return false;
}


}

