#ifndef ROBOCALC_STATEMACHINES_PUSHER_H_
#define ROBOCALC_STATEMACHINES_PUSHER_H_

#include "RoboCalcAPI/State.h"
#include "ePuck.h"
#include "TransportController.h"
#include "Timer.h"
#include "DataTypes.h"

class Pusher: public robochart::StateMachine {
	public:
		std::shared_ptr<robochart::neighbourDetected_channel> neighbourDetected;
	public:
		std::shared_ptr<robochart::goalSeen_channel> goalSeen;
	public:
		std::shared_ptr<robochart::objectSeen_channel> objectSeen;
	public:
		std::shared_ptr<robochart::Timer> T;
		std::shared_ptr<robochart::Timer> N;
		std::shared_ptr<robochart::Timer> C;
		std::shared_ptr<robochart::Timer> eT;
		std::shared_ptr<ePuck> R_ePuck;
		std::shared_ptr<TransportController> C_TransportController;
	public:
		const double close;
		const int Ta;
		const int Tb;
		const int Tc;
		const int Td;
		const int Te;
		const int S;
		int neighbours;
		double distance;
		double d;
		int n;
		bool goal;
	public:
		Pusher(
				std::shared_ptr<ePuck> R_ePuck, 
				std::shared_ptr<TransportController> C_TransportController, 
				std::shared_ptr<robochart::neighbourDetected_channel> neighbourDetected,
				std::shared_ptr<robochart::goalSeen_channel> goalSeen,
				std::shared_ptr<robochart::objectSeen_channel> objectSeen);
		~Pusher();
		int initial();
		virtual void execute();

	public:
		class I : public robochart::State {
			public:
				I(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("I"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
				}
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
		};
		class Searching : public robochart::State {
			public:
				Searching(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("Searching"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
				}
			void entry() {
				S_Pusher->eT->SetCounter(0);   
				R_ePuck->enableObjectWatch();
			}
			void during() {
				R_ePuck->searchObject();
			}
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
		};
		class MovingToObject : public robochart::State {
			public:
				MovingToObject(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("MovingToObject"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
						// instantiate states && add substates of machine
						std::shared_ptr<I> MovingToObject_I = std::make_shared<I>(R_ePuck, C_TransportController, S_Pusher);
						states.push_back(MovingToObject_I);
						std::shared_ptr<Watch> MovingToObject_Watch = std::make_shared<Watch>(R_ePuck, C_TransportController, S_Pusher);
						states.push_back(MovingToObject_Watch);
					
						std::shared_ptr<M0> MovingToObject_M0 = std::make_shared<M0>(R_ePuck, C_TransportController, S_Pusher, MovingToObject_I, MovingToObject_Watch);
						MovingToObject_I->transitions.push_back(MovingToObject_M0);
						std::shared_ptr<M1> MovingToObject_M1 = std::make_shared<M1>(R_ePuck, C_TransportController, S_Pusher, MovingToObject_Watch, MovingToObject_Watch);
						MovingToObject_Watch->transitions.push_back(MovingToObject_M1);
				}
			void during() {
				R_ePuck->moveToObject();
			}
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
			public:
				class I : public robochart::State {
					public:
						I(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("I"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
				};
				~MovingToObject() {
				}
				int initial() {
					return 0;
				}
				void execute() {
					State::execute();
				}
			public:
				class Watch : public robochart::State {
					public:
						Watch(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("Watch"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
				};
			public:
				class M0 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
					public:
						M0(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher)
						{}
				};
			public:
				class M1 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::objectSeen_event> reg_event;
					public:
						M1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								printf("channel size2 before: %ld\n", S_Pusher->objectSeen->size());
								reg_event = S_Pusher->objectSeen->reg("Pusher", robochart::Optional<double>());
								printf("channel size2 after: %ld\n", S_Pusher->objectSeen->size());
							}
						}
						bool check() {
							printf("testing check\n");
							if (S_Pusher->objectSeen->check(reg_event) == true) {
								printf("TREATING EVENT objectSeen!%f\n", std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value()); //modified
								S_Pusher->d = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();  //modified
								ClearEvent();
								S_Pusher->T->SetCounter(0);
								printf("RESETTING TIMER %s\n", S_Pusher->T->GetName().c_str());
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->objectSeen->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->objectSeen->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->distance >= 29 && S_Pusher->T->GetCounter() < S_Pusher->Ta) {
								printf("Transition M1 Condition: true\n");
								return true;
							}
							else {
								printf("Transition M1 Condition: false\n");
								return false;
							}
						}
						void action() {
							S_Pusher->distance = S_Pusher->d;
						}
				};
		};
		class ClosingInOnObject : public robochart::State {
			public:
				ClosingInOnObject(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("ClosingInOnObject"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
						// instantiate states && add substates of machine
						std::shared_ptr<I> ClosingInOnObject_I = std::make_shared<I>(R_ePuck, C_TransportController, S_Pusher);
						states.push_back(ClosingInOnObject_I);
						std::shared_ptr<Watch> ClosingInOnObject_Watch = std::make_shared<Watch>(R_ePuck, C_TransportController, S_Pusher);
						states.push_back(ClosingInOnObject_Watch);
					
						std::shared_ptr<C0> ClosingInOnObject_C0 = std::make_shared<C0>(R_ePuck, C_TransportController, S_Pusher, ClosingInOnObject_I, ClosingInOnObject_Watch);
						ClosingInOnObject_I->transitions.push_back(ClosingInOnObject_C0);
						std::shared_ptr<C1> ClosingInOnObject_C1 = std::make_shared<C1>(R_ePuck, C_TransportController, S_Pusher, ClosingInOnObject_Watch, ClosingInOnObject_Watch);
						ClosingInOnObject_Watch->transitions.push_back(ClosingInOnObject_C1);
				}
			void during() {
				R_ePuck->closeInOnObject();
			}
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
			public:
				class I : public robochart::State {
					public:
						I(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("I"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
				};
				~ClosingInOnObject() {
				}
				int initial() {
					return 0;
				}
				void execute() {
					State::execute();
				}
			public:
				class Watch : public robochart::State {
					public:
						Watch(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("Watch"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
				};
			public:
				class C0 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
					public:
						C0(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher)
						{}
				};
			public:
				class C1 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::objectSeen_event> reg_event;
					public:
						C1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->objectSeen->reg("Pusher", robochart::Optional<double>());
								printf("channel size2: %ld\n", S_Pusher->objectSeen->size());
							}
						}
						bool check() {
							if (S_Pusher->objectSeen->check(reg_event) == true) {
								printf("TREATING EVENT objectSeen!%f\n", std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value()); //modified
								S_Pusher->d = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								S_Pusher->T->SetCounter(0);
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->objectSeen->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->objectSeen->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->distance < S_Pusher->close && S_Pusher->T->GetCounter() < S_Pusher->Ta) {
								return true;
							}
							else {
								return false;
							}
						}
						void action() {
							S_Pusher->distance = S_Pusher->d;
						}
				};
		};
		class Scanning : public robochart::State {
			public:
				Scanning(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("Scanning"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
						// instantiate states && add substates of machine
						std::shared_ptr<I> Scanning_I = std::make_shared<I>(R_ePuck, C_TransportController, S_Pusher);
						states.push_back(Scanning_I);
						std::shared_ptr<Watch> Scanning_Watch = std::make_shared<Watch>(R_ePuck, C_TransportController, S_Pusher);
						states.push_back(Scanning_Watch);
					
//						std::shared_ptr<S0> Scanning_S0 = std::make_shared<S0>(R_ePuck, C_TransportController, S_Pusher, Scanning_I, Scanning_Watch);
//						Scanning_I->transitions.push_back(Scanning_S0);
//						std::shared_ptr<S4> Scanning_S4 = std::make_shared<S4>(R_ePuck, C_TransportController, S_Pusher, Scanning_Watch, Scanning_Watch);
//						Scanning_Watch->transitions.push_back(Scanning_S4);
//						std::shared_ptr<t0> Scanning_t0 = std::make_shared<t0>(R_ePuck, C_TransportController, S_Pusher, Scanning_Watch, Scanning_Watch);
//						Scanning_Watch->transitions.push_back(Scanning_t0);
//						std::shared_ptr<t1> Scanning_t1 = std::make_shared<t1>(R_ePuck, C_TransportController, S_Pusher, Scanning_Watch, Scanning_Watch);
//						Scanning_Watch->transitions.push_back(Scanning_t1);
//						std::shared_ptr<t2> Scanning_t2 = std::make_shared<t2>(R_ePuck, C_TransportController, S_Pusher, Scanning_Watch, Scanning_Watch);
//						Scanning_Watch->transitions.push_back(Scanning_t2);
//						std::shared_ptr<t3> Scanning_t3 = std::make_shared<t3>(R_ePuck, C_TransportController, S_Pusher, Scanning_Watch, Scanning_Watch);
//						Scanning_Watch->transitions.push_back(Scanning_t3);
//						std::shared_ptr<t4> Scanning_t4 = std::make_shared<t4>(R_ePuck, C_TransportController, S_Pusher, Scanning_Watch, Scanning_Watch);
//						Scanning_Watch->transitions.push_back(Scanning_t4);
//						std::shared_ptr<t5> Scanning_t5 = std::make_shared<t5>(R_ePuck, C_TransportController, S_Pusher, Scanning_Watch, Scanning_Watch);
//						Scanning_Watch->transitions.push_back(Scanning_t5);
//						std::shared_ptr<t6> Scanning_t6 = std::make_shared<t6>(R_ePuck, C_TransportController, S_Pusher, Scanning_Watch, Scanning_Watch);
//						Scanning_Watch->transitions.push_back(Scanning_t6);
//						std::shared_ptr<t7> Scanning_t7 = std::make_shared<t7>(R_ePuck, C_TransportController, S_Pusher, Scanning_Watch, Scanning_Watch);
//						Scanning_Watch->transitions.push_back(Scanning_t7);
				}
			void entry() {
				S_Pusher->eT->SetCounter(0); 
				S_Pusher->goal = false;
				R_ePuck->enableGoalFinding();
				R_ePuck->enableNeighbourDetection();
			}
			void during() {
				R_ePuck->scanAndAlign();
			}
			void exit() {
				R_ePuck->disableGoalFinding();
			}
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
			public:
				class I : public robochart::State {
					public:
						I(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("I"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
				};
				~Scanning() {
				}
				int initial() {
					return 0;
				}
				void execute() {
					State::execute();
				}
			public:
				class Watch : public robochart::State {
					public:
						Watch(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("Watch"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
				};
			public:
				class S0 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
					public:
						S0(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher)
						{}
				};
			public:
				class S4 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::goalSeen_event> reg_event;
					public:
						S4(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->goalSeen->reg("Pusher");
							}
						}
						bool check() {
							if (S_Pusher->goalSeen->check(reg_event) == true) {
								printf("TREATING EVENT goalSeen!\n"); 
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->goalSeen->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->goalSeen->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						void action() {
							S_Pusher->goal = true;
						}
				};
			public:
				class t0 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::objectSeen_event> reg_event;
					public:
						t0(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->objectSeen->reg("Pusher", robochart::Optional<double>());
							}
						}
						bool check() {
							if (S_Pusher->objectSeen->check(reg_event) == true) {
								printf("TREATING EVENT objectSeen!%f\n", std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value()); //modified
								S_Pusher->d = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->objectSeen->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->objectSeen->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->distance == 0 && S_Pusher->d == 0) {
								return true;
							}
							else {
								return false;
							}
						}
				};
			public:
				class t1 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::objectSeen_event> reg_event;
					public:
						t1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->objectSeen->reg("Pusher", robochart::Optional<double>());
							}
						}
						bool check() {
							if (S_Pusher->objectSeen->check(reg_event) == true) {
								printf("TREATING EVENT objectSeen!%f\n", std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value()); //modified
								S_Pusher->d = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->objectSeen->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->objectSeen->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->distance == 0 && S_Pusher->d > 0) {
								return true;
							}
							else {
								return false;
							}
						}
						void action() {
							S_Pusher->C->SetCounter(0);
							S_Pusher->distance = S_Pusher->d;
						}
				};
			public:
				class t2 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::neighbourDetected_event> reg_event;
					public:
						t2(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->neighbourDetected->reg("Pusher", robochart::Optional<int>());
							}
						}
						bool check() {
							if (S_Pusher->neighbourDetected->check(reg_event) == true) {
								S_Pusher->n = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->neighbourDetected->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->neighbourDetected->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->neighbours < 2 && S_Pusher->n < 2) {
								return true;
							}
							else {
								return false;
							}
						}
				};
			public:
				class t3 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::neighbourDetected_event> reg_event;
					public:
						t3(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->neighbourDetected->reg("Pusher", robochart::Optional<int>());
							}
						}
						bool check() {
							if (S_Pusher->neighbourDetected->check(reg_event) == true) {
								S_Pusher->n = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->neighbourDetected->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->neighbourDetected->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->neighbours >= 2 && S_Pusher->n < 2) {
								return true;
							}
							else {
								return false;
							}
						}
						void action() {
							S_Pusher->N->SetCounter(0);
							S_Pusher->neighbours = S_Pusher->n;
						}
				};
			public:
				class t4 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::neighbourDetected_event> reg_event;
					public:
						t4(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->neighbourDetected->reg("Pusher", robochart::Optional<int>());
							}
						}
						bool check() {
							if (S_Pusher->neighbourDetected->check(reg_event) == true) {
								S_Pusher->n = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->neighbourDetected->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->neighbourDetected->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->neighbours < 2 && S_Pusher->n >= 2) {
								return true;
							}
							else {
								return false;
							}
						}
						void action() {
							S_Pusher->neighbours = S_Pusher->n;
						}
				};
			public:
				class t5 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::objectSeen_event> reg_event;
					public:
						t5(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->objectSeen->reg("Pusher", robochart::Optional<double>());
							}
						}
						bool check() {
							if (S_Pusher->objectSeen->check(reg_event) == true) {
								printf("TREATING EVENT objectSeen!%f\n", std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value()); //modified
								S_Pusher->d = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->objectSeen->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->objectSeen->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->distance > 0 && S_Pusher->d == 0) {
								return true;
							}
							else {
								return false;
							}
						}
						void action() {
							S_Pusher->distance = S_Pusher->d;
						}
				};
			public:
				class t6 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::objectSeen_event> reg_event;
					public:
						t6(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->objectSeen->reg("Pusher", robochart::Optional<double>());
							}
						}
						bool check() {
							if (S_Pusher->objectSeen->check(reg_event) == true) {
								printf("TREATING EVENT objectSeen!%f\n", std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value()); //modified
								S_Pusher->d = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->objectSeen->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->objectSeen->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->distance > 0 && S_Pusher->d > 0) {
								return true;
							}
							else {
								return false;
							}
						}
				};
			public:
				class t7 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::neighbourDetected_event> reg_event;
					public:
						t7(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->neighbourDetected->reg("Pusher", robochart::Optional<int>());
							}
						}
						bool check() {
							if (S_Pusher->neighbourDetected->check(reg_event) == true) {
								S_Pusher->n = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->neighbourDetected->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->neighbourDetected->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->neighbours >= 2 && S_Pusher->n >= 2) {
								return true;
							}
							else {
								return false;
							}
						}
				};
		};
		class Pushing : public robochart::State {
			public:
				Pushing(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("Pushing"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
						// instantiate states && add substates of machine
						std::shared_ptr<I> Pushing_I = std::make_shared<I>(R_ePuck, C_TransportController, S_Pusher);
						states.push_back(Pushing_I);
						std::shared_ptr<Watch> Pushing_Watch = std::make_shared<Watch>(R_ePuck, C_TransportController, S_Pusher);
						states.push_back(Pushing_Watch);
					
//						std::shared_ptr<P0> Pushing_P0 = std::make_shared<P0>(R_ePuck, C_TransportController, S_Pusher, Pushing_I, Pushing_Watch);
//						Pushing_I->transitions.push_back(Pushing_P0);
//						std::shared_ptr<t0> Pushing_t0 = std::make_shared<t0>(R_ePuck, C_TransportController, S_Pusher, Pushing_Watch, Pushing_Watch);
//						Pushing_Watch->transitions.push_back(Pushing_t0);
//						std::shared_ptr<t1> Pushing_t1 = std::make_shared<t1>(R_ePuck, C_TransportController, S_Pusher, Pushing_Watch, Pushing_Watch);
//						Pushing_Watch->transitions.push_back(Pushing_t1);
//						std::shared_ptr<t2> Pushing_t2 = std::make_shared<t2>(R_ePuck, C_TransportController, S_Pusher, Pushing_Watch, Pushing_Watch);
//						Pushing_Watch->transitions.push_back(Pushing_t2);
//						std::shared_ptr<t3> Pushing_t3 = std::make_shared<t3>(R_ePuck, C_TransportController, S_Pusher, Pushing_Watch, Pushing_Watch);
//						Pushing_Watch->transitions.push_back(Pushing_t3);
//						std::shared_ptr<t4> Pushing_t4 = std::make_shared<t4>(R_ePuck, C_TransportController, S_Pusher, Pushing_Watch, Pushing_Watch);
//						Pushing_Watch->transitions.push_back(Pushing_t4);
//						std::shared_ptr<t5> Pushing_t5 = std::make_shared<t5>(R_ePuck, C_TransportController, S_Pusher, Pushing_Watch, Pushing_Watch);
//						Pushing_Watch->transitions.push_back(Pushing_t5);
//						std::shared_ptr<t6> Pushing_t6 = std::make_shared<t6>(R_ePuck, C_TransportController, S_Pusher, Pushing_Watch, Pushing_Watch);
//						Pushing_Watch->transitions.push_back(Pushing_t6);
//						std::shared_ptr<t7> Pushing_t7 = std::make_shared<t7>(R_ePuck, C_TransportController, S_Pusher, Pushing_Watch, Pushing_Watch);
//						Pushing_Watch->transitions.push_back(Pushing_t7);
				}
			void during() {
				R_ePuck->pushObject();
			}
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
			public:
				class I : public robochart::State {
					public:
						I(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("I"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
				};
				~Pushing() {
				}
				int initial() {
					return 0;
				}
				void execute() {
					State::execute();
				}
			public:
				class Watch : public robochart::State {
					public:
						Watch(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("Watch"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
				};
			public:
				class P0 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
					public:
						P0(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher)
						{}
				};
			public:
				class t0 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::objectSeen_event> reg_event;
					public:
						t0(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->objectSeen->reg("Pusher", robochart::Optional<double>());
							}
						}
						bool check() {
							if (S_Pusher->objectSeen->check(reg_event) == true) {
								printf("TREATING EVENT objectSeen!%f\n", std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value()); //modified
								S_Pusher->d = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->objectSeen->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->objectSeen->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->distance == 0 && S_Pusher->d == 0) {
								return true;
							}
							else {
								return false;
							}
						}
				};
			public:
				class t1 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::objectSeen_event> reg_event;
					public:
						t1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->objectSeen->reg("Pusher", robochart::Optional<double>());
							}
						}
						bool check() {
							if (S_Pusher->objectSeen->check(reg_event) == true) {
								printf("TREATING EVENT objectSeen!%f\n", std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value()); //modified
								S_Pusher->d = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->objectSeen->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->objectSeen->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->distance == 0 && S_Pusher->d > 0) {
								return true;
							}
							else {
								return false;
							}
						}
						void action() {
							S_Pusher->C->SetCounter(0);
							S_Pusher->distance = S_Pusher->d;
						}
				};
			public:
				class t2 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::neighbourDetected_event> reg_event;
					public:
						t2(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->neighbourDetected->reg("Pusher", robochart::Optional<int>());
							}
						}
						bool check() {
							if (S_Pusher->neighbourDetected->check(reg_event) == true) {
								S_Pusher->n = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->neighbourDetected->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->neighbourDetected->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->neighbours < 2 && S_Pusher->n < 2) {
								return true;
							}
							else {
								return false;
							}
						}
				};
			public:
				class t3 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::neighbourDetected_event> reg_event;
					public:
						t3(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->neighbourDetected->reg("Pusher", robochart::Optional<int>());
							}
						}
						bool check() {
							if (S_Pusher->neighbourDetected->check(reg_event) == true) {
								S_Pusher->n = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->neighbourDetected->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->neighbourDetected->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->neighbours >= 2 && S_Pusher->n < 2) {
								return true;
							}
							else {
								return false;
							}
						}
						void action() {
							S_Pusher->N->SetCounter(0);
							S_Pusher->neighbours = S_Pusher->n;
						}
				};
			public:
				class t4 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::neighbourDetected_event> reg_event;
					public:
						t4(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->neighbourDetected->reg("Pusher", robochart::Optional<int>());
							}
						}
						bool check() {
							if (S_Pusher->neighbourDetected->check(reg_event) == true) {
								S_Pusher->n = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->neighbourDetected->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->neighbourDetected->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->neighbours < 2 && S_Pusher->n >= 2) {
								return true;
							}
							else {
								return false;
							}
						}
						void action() {
							S_Pusher->neighbours = S_Pusher->n;
						}
				};
			public:
				class t5 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::objectSeen_event> reg_event;
					public:
						t5(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->objectSeen->reg("Pusher", robochart::Optional<double>());
							}
						}
						bool check() {
							if (S_Pusher->objectSeen->check(reg_event) == true) {
								printf("TREATING EVENT objectSeen!%f\n", std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value()); //modified
								S_Pusher->d = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->objectSeen->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->objectSeen->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->distance > 0 && S_Pusher->d == 0) {
								return true;
							}
							else {
								return false;
							}
						}
						void action() {
							S_Pusher->distance = S_Pusher->d;
						}
				};
			public:
				class t6 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::objectSeen_event> reg_event;
					public:
						t6(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->objectSeen->reg("Pusher", robochart::Optional<double>());
							}
						}
						bool check() {
							if (S_Pusher->objectSeen->check(reg_event) == true) {
								printf("TREATING EVENT objectSeen!%f\n", std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value()); //modified
								S_Pusher->d = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->objectSeen->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->objectSeen->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->distance > 0 && S_Pusher->d > 0) {
								return true;
							}
							else {
								return false;
							}
						}
				};
			public:
				class t7 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<TransportController> C_TransportController;
						std::shared_ptr<Pusher> S_Pusher;
						std::shared_ptr<robochart::neighbourDetected_event> reg_event;
					public:
						t7(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
						{}
						void reg() {
							if (reg_event == nullptr) {
								reg_event = S_Pusher->neighbourDetected->reg("Pusher", robochart::Optional<int>());
							}
						}
						bool check() {
							if (S_Pusher->neighbourDetected->check(reg_event) == true) {
								S_Pusher->n = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
								ClearEvent();
								return true;
							}
							else {
								cancel();
								return false;
							}
						}
						void cancel() {
							if (reg_event != nullptr) {
								S_Pusher->neighbourDetected->cancel(reg_event);
								reg_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Pusher->neighbourDetected->acceptAndDelete(reg_event);
							reg_event = nullptr;
						}
						bool condition() {
							if (S_Pusher->neighbours >= 2 && S_Pusher->n >= 2) {
								return true;
							}
							else {
								return false;
							}
						}
				};
		};
		class Evading : public robochart::State {
			public:
				Evading(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("Evading"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
				}
			void entry() {
				S_Pusher->eT->SetCounter(0);
				R_ePuck->disableObjectWatch();
				R_ePuck->disableNeighbourDetection();
			}
			void during() {
				R_ePuck->evade();
			}
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
		};
		class MovingAround : public robochart::State {
			public:
				MovingAround(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher) : State("MovingAround"), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher) {
				}
			void entry() {
				S_Pusher->eT->SetCounter(0);
				R_ePuck->disableObjectWatch();
				R_ePuck->disableNeighbourDetection();
			}
			void during() {
				R_ePuck->moveAroundObject();
			}
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
		};

	public:
		class I0 : public robochart::Transition {
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
			public:
				I0(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
				   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher)
				{}
		};
		class TS0 : public robochart::Transition {
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
				std::shared_ptr<robochart::objectSeen_event> reg_event;
			public:
				TS0(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
				   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher), reg_event(nullptr)
				{}
				void reg() {
					if (reg_event == nullptr) {
						reg_event = S_Pusher->objectSeen->reg("Pusher", robochart::Optional<double>());
					}
				}
				bool check() {
					if (S_Pusher->objectSeen->check(reg_event) == true) {
						printf("TREATING EVENT objectSeen!%f\n", std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value()); //modified
						S_Pusher->distance = std::get<0>(*reg_event->getOther().value().lock()->getParameters()).value();
						ClearEvent();
						S_Pusher->T->SetCounter(0);
						return true;
					}
					else {
						cancel();
						return false;
					}
				}
				void cancel() {
					if (reg_event != nullptr) {
						S_Pusher->objectSeen->cancel(reg_event);
						reg_event = nullptr;
					}
				}
				void ClearEvent() {
					S_Pusher->objectSeen->acceptAndDelete(reg_event);
					reg_event = nullptr;
				}
		};
		class TM0 : public robochart::Transition {
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
			public:
				TM0(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
				   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher)
				{}
				bool condition() {
					if (S_Pusher->T->GetCounter() >= S_Pusher->Ta) {
						return true;
					}
					else {
						return false;
					}
				}
		};
		class TM1 : public robochart::Transition {
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
			public:
				TM1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
				   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher)
				{}
				bool condition() {
					if (S_Pusher->distance < S_Pusher->close && S_Pusher->T->GetCounter() < S_Pusher->Ta) {
						return true;
					}
					else {
						return false;
					}
				}
		};
		class CIO0 : public robochart::Transition {
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
			public:
				CIO0(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
				   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher)
				{}
				bool condition() {
					if (S_Pusher->T->GetCounter() >= S_Pusher->Ta) {
						return true;
					}
					else {
						return false;
					}
				}
		};
		class CIO1 : public robochart::Transition {
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
			public:
				CIO1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
				   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher)
				{}
				bool condition() {
					if (S_Pusher->distance < 29) { 
						return true;
					}
					else {
						return false;
					}
				}
				void action() {
					S_Pusher->neighbours = 2;
				}
		};
		class SC0 : public robochart::Transition {
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
			public:
				SC0(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
				   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher)
				{}
				bool condition() {
					if (S_Pusher->goal && S_Pusher->eT->GetCounter() >= S_Pusher->S) {
						return true;
					}
					else {
						return false;
					}
				}
		};
		class SC1 : public robochart::Transition {
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
			public:
				SC1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
				   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher)
				{}
				bool condition() {
					if (!S_Pusher->goal && S_Pusher->eT->GetCounter() >= S_Pusher->S) {
						return true;
					}
					else {
						return false;
					}
				}
		};
		class SP0 : public robochart::Transition {
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
			public:
				SP0(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
				   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher)
				{}
				bool condition() {
					if (S_Pusher->distance > 0 && S_Pusher->C->GetCounter() >= S_Pusher->Tc) {
						return true;
					}
					else {
						return false;
					}
				}
		};
		class SP1 : public robochart::Transition {
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
			public:
				SP1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
				   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher)
				{}
				bool condition() {
					if (S_Pusher->neighbours < 2 && S_Pusher->N->GetCounter() >= S_Pusher->Tb) {
						return true;
					}
					else {
						return false;
					}
				}
		};
		class E0 : public robochart::Transition {
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
			public:
				E0(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
				   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher)
				{}
				bool condition() {
					if (S_Pusher->eT->GetCounter() >= S_Pusher->Te) {
						return true;
					}
					else {
						return false;
					}
				}
		};
		class M0 : public robochart::Transition {
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<TransportController> C_TransportController;
				std::shared_ptr<Pusher> S_Pusher;
			public:
				M0(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<TransportController> C_TransportController, std::shared_ptr<Pusher> S_Pusher, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
				   robochart::Transition(src, tgt), R_ePuck(R_ePuck), C_TransportController(C_TransportController), S_Pusher(S_Pusher)
				{}
				bool condition() {
					if (S_Pusher->eT->GetCounter() >= S_Pusher->Td) {
						return true;
					}
					else {
						return false;
					}
				}
		};
	
};

#endif
