#include "Pusher.h"  

Pusher::Pusher(
			std::shared_ptr<ePuck> R_ePuck, 
			std::shared_ptr<TransportController> C_TransportController, 
			std::shared_ptr<robochart::neighbourDetected_channel> neighbourDetected,
			std::shared_ptr<robochart::goalSeen_channel> goalSeen,
			std::shared_ptr<robochart::objectSeen_channel> objectSeen) :R_ePuck(R_ePuck), C_TransportController(C_TransportController), StateMachine("Pusher"), neighbourDetected(neighbourDetected), goalSeen(goalSeen), objectSeen(objectSeen), close(35), Ta(INT_MAX), Tb(INT_MAX), Tc(INT_MAX), Td(20), Te(20), S(1), neighbours(2), distance(0), d(0), n(0), goal(false)
{
	T = std::make_shared<robochart::Timer>(std::string("T"));  //modified
	N = std::make_shared<robochart::Timer>(std::string("N"));
	C = std::make_shared<robochart::Timer>(std::string("C"));
	eT = std::make_shared<robochart::Timer>(std::string("eT"));
	std::shared_ptr<Pusher> ptr(this);
	// instantiate states && add substates of machine
	std::shared_ptr<I> S_Pusher_I = std::make_shared<I>(R_ePuck, C_TransportController, ptr);
	states.push_back(S_Pusher_I);
	std::shared_ptr<Searching> S_Pusher_Searching = std::make_shared<Searching>(R_ePuck, C_TransportController, ptr);
	states.push_back(S_Pusher_Searching);
	std::shared_ptr<MovingToObject> S_Pusher_MovingToObject = std::make_shared<MovingToObject>(R_ePuck, C_TransportController, ptr);
	states.push_back(S_Pusher_MovingToObject);
	std::shared_ptr<ClosingInOnObject> S_Pusher_ClosingInOnObject = std::make_shared<ClosingInOnObject>(R_ePuck, C_TransportController, ptr);
	states.push_back(S_Pusher_ClosingInOnObject);
	std::shared_ptr<Scanning> S_Pusher_Scanning = std::make_shared<Scanning>(R_ePuck, C_TransportController, ptr);
	states.push_back(S_Pusher_Scanning);
	std::shared_ptr<Pushing> S_Pusher_Pushing = std::make_shared<Pushing>(R_ePuck, C_TransportController, ptr);
	states.push_back(S_Pusher_Pushing);
	std::shared_ptr<Evading> S_Pusher_Evading = std::make_shared<Evading>(R_ePuck, C_TransportController, ptr);
	states.push_back(S_Pusher_Evading);
	std::shared_ptr<MovingAround> S_Pusher_MovingAround = std::make_shared<MovingAround>(R_ePuck, C_TransportController, ptr);
	states.push_back(S_Pusher_MovingAround);

	std::shared_ptr<I0> S_Pusher_I0 = std::make_shared<I0>(R_ePuck, C_TransportController, ptr, S_Pusher_I, S_Pusher_Searching);
	S_Pusher_I->transitions.push_back(S_Pusher_I0);
	std::shared_ptr<TS0> S_Pusher_TS0 = std::make_shared<TS0>(R_ePuck, C_TransportController, ptr, S_Pusher_Searching, S_Pusher_MovingToObject);
	S_Pusher_Searching->transitions.push_back(S_Pusher_TS0);
	std::shared_ptr<TM0> S_Pusher_TM0 = std::make_shared<TM0>(R_ePuck, C_TransportController, ptr, S_Pusher_MovingToObject, S_Pusher_Searching);
	S_Pusher_MovingToObject->transitions.push_back(S_Pusher_TM0);
	std::shared_ptr<TM1> S_Pusher_TM1 = std::make_shared<TM1>(R_ePuck, C_TransportController, ptr, S_Pusher_MovingToObject, S_Pusher_ClosingInOnObject);
	S_Pusher_MovingToObject->transitions.push_back(S_Pusher_TM1);
	std::shared_ptr<CIO0> S_Pusher_CIO0 = std::make_shared<CIO0>(R_ePuck, C_TransportController, ptr, S_Pusher_ClosingInOnObject, S_Pusher_Searching);
	S_Pusher_ClosingInOnObject->transitions.push_back(S_Pusher_CIO0);
	std::shared_ptr<CIO1> S_Pusher_CIO1 = std::make_shared<CIO1>(R_ePuck, C_TransportController, ptr, S_Pusher_ClosingInOnObject, S_Pusher_Scanning);
	S_Pusher_ClosingInOnObject->transitions.push_back(S_Pusher_CIO1);
	std::shared_ptr<SC0> S_Pusher_SC0 = std::make_shared<SC0>(R_ePuck, C_TransportController, ptr, S_Pusher_Scanning, S_Pusher_MovingAround);
	S_Pusher_Scanning->transitions.push_back(S_Pusher_SC0);
	std::shared_ptr<SC1> S_Pusher_SC1 = std::make_shared<SC1>(R_ePuck, C_TransportController, ptr, S_Pusher_Scanning, S_Pusher_Pushing);
	S_Pusher_Scanning->transitions.push_back(S_Pusher_SC1);
	std::shared_ptr<SP0> S_Pusher_SP0 = std::make_shared<SP0>(R_ePuck, C_TransportController, ptr, S_Pusher_Pushing, S_Pusher_Evading);
	S_Pusher_Pushing->transitions.push_back(S_Pusher_SP0);
	std::shared_ptr<SP1> S_Pusher_SP1 = std::make_shared<SP1>(R_ePuck, C_TransportController, ptr, S_Pusher_Pushing, S_Pusher_Scanning);
	S_Pusher_Pushing->transitions.push_back(S_Pusher_SP1);
	std::shared_ptr<E0> S_Pusher_E0 = std::make_shared<E0>(R_ePuck, C_TransportController, ptr, S_Pusher_Evading, S_Pusher_Searching);
	S_Pusher_Evading->transitions.push_back(S_Pusher_E0);
	std::shared_ptr<M0> S_Pusher_M0 = std::make_shared<M0>(R_ePuck, C_TransportController, ptr, S_Pusher_MovingAround, S_Pusher_Searching);
	S_Pusher_MovingAround->transitions.push_back(S_Pusher_M0);

	stage = s_Enter;
}

Pusher::~Pusher() {
}

int Pusher::initial() {
	return 0;
}

void Pusher::execute() {
	T->IncCounter();
	N->IncCounter();
	C->IncCounter();
	eT->IncCounter();
	StateMachine::execute();
}
