#ifndef ROBOCALC_HARDWARECOMPONENT_H_
#define ROBOCALC_HARDWARECOMPONENT_H_

// Sensors
#include <argos3/plugins/robots/e-puck/control_interface/ci_epuck_proximity_sensor.h>
#include <argos3/plugins/robots/e-puck/control_interface/ci_epuck_light_sensor.h>
#include <argos3/plugins/robots/e-puck/control_interface/ci_epuck_range_and_bearing_sensor.h>
#include <argos3/plugins/robots/e-puck/control_interface/ci_epuck_ircom_sensor.h>
#include <argos3/plugins/robots/e-puck/control_interface/ci_epuck_omnidirectional_camera_sensor.h>

// Actuators
#include <argos3/plugins/robots/e-puck/control_interface/ci_epuck_wheels_actuator.h>
#include <argos3/plugins/robots/e-puck/control_interface/ci_epuck_base_leds_actuator.h>
#include <argos3/plugins/robots/e-puck/control_interface/ci_epuck_rgb_leds_actuator.h>
#include <argos3/plugins/robots/e-puck/control_interface/ci_epuck_range_and_bearing_actuator.h>
#include <argos3/plugins/robots/e-puck/control_interface/ci_epuck_ircom_actuator.h>

using namespace argos;


extern CRadians heading;

class HardwareComponent {

public:
	HardwareComponent() {}
	virtual ~HardwareComponent() {}
	virtual void Sensors() = 0;
	virtual void Actuators() = 0;

    // Sensors
    CCI_EPuckProximitySensor* proximity_sensor;
    CCI_EPuckLightSensor* light_sensor;
    CCI_EPuckRangeAndBearingSensor* rab_sensor;
    CCI_EPuckIRComSensor* ircom_sensor;
    CCI_EPuckOmnidirectionalCameraSensor* omnidirectional_camera_sensor;

    // Actuators
    CCI_EPuckWheelsActuator* wheels_actuator;
    CCI_EPuckBaseLEDsActuator* base_leds_actuator;
    CCI_EPuckRGBLEDsActuator* rgb_leds_actuator;
    CCI_EPuckRangeAndBearingActuator* rab_actuator;
    CCI_EPuckIRComActuator* ircom_actuator;
};

#endif



