#ifndef ROBOCALC_MODULES_SYSTEM_H_
#define ROBOCALC_MODULES_SYSTEM_H_

#include "ePuck.h"
#include "TransportController.h"
#include "ChannelTypes.h"

#include <argos3/core/control_interface/ci_controller.h>

class System : public CCI_Controller {
public:
	System() :
			System_ePuck(nullptr),
			System_TransportController(nullptr),
			objectSeen(std::make_shared<robochart::objectSeen_channel>("objectSeen")),
			neighbourDetected(std::make_shared<robochart::neighbourDetected_channel>("neighbourDetected")),
			goalSeen(std::make_shared<robochart::goalSeen_channel>("goalSeen")) {}
	virtual ~System() {}

	void Init();
	void Execute();
    virtual void Init(TConfigurationNode &t_node);
    virtual void ControlStep();

private:
	std::shared_ptr<robochart::objectSeen_channel> objectSeen;
	std::shared_ptr<robochart::neighbourDetected_channel> neighbourDetected;
	std::shared_ptr<robochart::goalSeen_channel> goalSeen;
	std::shared_ptr<ePuck> System_ePuck;
	std::shared_ptr<TransportController> System_TransportController;

};

#endif
