#include "System.h"
#include "Pusher.h"

void System::Init() {
	System_ePuck = std::make_shared<ePuck> (objectSeen, goalSeen, neighbourDetected);
	System_TransportController = std::make_shared<TransportController> (System_ePuck, objectSeen, goalSeen, neighbourDetected);
	std::shared_ptr<Pusher> TransportController_Pusher = std::make_shared<Pusher>(System_ePuck, System_TransportController, neighbourDetected, goalSeen, objectSeen);
	System_TransportController->stm = TransportController_Pusher;
}

void System::Execute() {
	System_ePuck->Sensors();
	System_TransportController->execute();
	System_ePuck->Actuators();
}

void System::Init(TConfigurationNode &t_node)
{
	Init();

    // Sensors
	System_ePuck->IMotionControl::proximity_sensor = GetSensor<CCI_EPuckProximitySensor>("epuck_proximity");
	System_ePuck->IGoalWatch::light_sensor = GetSensor<CCI_EPuckLightSensor>("epuck_light");
	System_ePuck->IObjectWatch::omnidirectional_camera_sensor = GetSensor<CCI_EPuckOmnidirectionalCameraSensor>("epuck_omnidirectional_camera");

    // Actuators
	System_ePuck->IMotionControl::wheels_actuator = GetActuator<CCI_EPuckWheelsActuator>("epuck_wheels");

    // Extract robot ID from name
    std::string robot_name = GetId(); // Get this robot's name
    robot_name = robot_name.substr(2, robot_name.size()); // Cut off the 'ep' at the start, leaving just the number
    System_ePuck->robot_id = atoi(robot_name.c_str()); // Convert to number (as string) to integer ID

    // Enable camera filtering
    System_ePuck->IObjectWatch::omnidirectional_camera_sensor->Enable();
}

void System::ControlStep() {
	System_ePuck->IMotionControl::control_step++;

    printf("\n\n\n[INFO]\t\trobot: %s, control step: %d\n", GetId().c_str(), System_ePuck->IMotionControl::control_step);
	Execute();
}

REGISTER_CONTROLLER(System, "epuck_transport_controller")


