
#ifndef ROBOCALC_TIMER_H_
#define ROBOCALC_TIMER_H_

#include <string>

//modified
namespace robochart {

class Timer {
public:

	Timer(std::string name) : name(name), counter(0), waitFlag(false), waitPeoriod(0), startingCounter(INT_MAX)
	{}

	int GetCounter() const {
		return counter;
	}

	void SetCounter(int i) {counter = i;}

	void IncCounter() {
		counter++;
		if (counter - startingCounter >= waitPeoriod) {
			waitFlag = false;
			startingCounter = INT_MAX;
		}
		printf("%s counter: %d\n", name.c_str(), counter);
	}

	void Wait(int i) {
		waitFlag = true;
		waitPeoriod = i;
		startingCounter = counter;
	}

	bool CheckWaitStatus() {
		return waitFlag;
	}

	std::string GetName() {
		return name;
	}

private:
	int counter, waitPeoriod, startingCounter;
	bool waitFlag;
	std::string name;
};

}

#endif
