
#ifndef ROBOCALC_STATE_H_
#define ROBOCALC_STATE_H_

#include <vector>
#include <memory>

namespace robochart {
class Transition;
class State {

public:
	std::string name;
	State(std::string n) : name(n), stage(s_Inactive) {}
	virtual ~State() { printf("Deleting state %s\n", name.c_str()); }
	virtual void entry() {}
	virtual void during() {}
	virtual void exit() {}
	virtual int initial() { return -1; }

	enum Stages {
		s_Enter, s_Execute, s_Exit, s_Inactive
	};
	Stages stage;
	std::vector<std::shared_ptr<State>> states;
	std::vector<std::shared_ptr<Transition>> transitions;
	virtual void execute();

	bool try_transitions();

	bool try_execute_substates(std::vector<std::shared_ptr<State>> s);

	void cancel_transitions(int i);
};

class StateMachine: public State {
public:
	StateMachine(std::string n): State(n) {}
	virtual ~StateMachine() {}
};

class Transition {
private:
	std::weak_ptr<State> source, target;
public:
	Transition(std::weak_ptr<State> src, std::weak_ptr<State> tgt) :
			source(src), target(tgt) {

	}
	virtual void reg() {}
	virtual bool check() { return true; }
	virtual void cancel() {}
	virtual bool condition() { return true; }
	virtual void action() {}
	virtual void ClearEvent() {};
	virtual ~Transition() { source.reset(); target.reset(); printf("Deleting transition\n");}
	bool execute();
};

}

#endif

