
#ifndef ROBOCALC_EVENT_H_
#define ROBOCALC_EVENT_H_

#include "Optional.h"
#include <vector>
#include <sstream>
#include <memory>

namespace robochart {

template<typename ...Args>   //variadic template
class Event {
private:
	std::string channel;
	std::string source;
	std::shared_ptr<std::tuple<Args...>> parameters;
	Optional<std::weak_ptr<Event<Args...>>> other;
	bool accepted;
public:
	Event(std::string c, std::string id, Args ... args) :
			channel(c), source(id), other(), accepted(false), parameters(
					std::make_shared<std::tuple<Args...>>(std::make_tuple(args...))) {
	}
	virtual ~Event() {
	}
	std::shared_ptr<std::tuple<Args...>> getParameters() {
		return parameters;
	}
	void setParameter(const uint i, std::string s) {
		std::get<i>(parameters).setValue(s);
	}
	Optional<std::string> getSource() {
		return source;
	}
	Optional<std::weak_ptr<Event<Args...>>> getOther() {
		return other;
	}
	void setOther(std::weak_ptr<Event<Args...>> s) {
		other = Optional<std::weak_ptr<Event<Args...>>>(s);
	}
	void accept() {
		accepted = true;
	}
	bool isAccepted() {
		return accepted;
	}

	//if two events come from different sources and their types are the same, these two events are compatible
	bool compatible(std::shared_ptr<Event<Args...>> e) {
		Optional<std::string> e1, e2;
		e1 = getSource();
		e2 = e->getSource();
		//e1.value().compare(e2.value()) != 0: if the two strings are different, which means the two events comes from different components, we say it is compatible...
		if (e1.exists() && e2.exists() && e1.value().compare(e2.value()) != 0
				//&& getParameters().size() == e->getParameters().size()
		) {
			printf("Event compatible!\n");
			return true;
		} else {
			printf("Event not compatible!\n");
			return false;
		}
	}

	//set the reference of the matched event for sync/async communication
	void match(std::shared_ptr<Event<Args...>> e) {
		if (!compatible(e))
			return;
		setOther(e);
	}

	std::string getChannel() {
		return channel;
	}
};

}

#endif

