#include "IObjectWatch.h"

CRadians heading;

IObjectWatch::IObjectWatch
			(std::shared_ptr<robochart::objectSeen_channel> objectSeen): objectSeen(objectSeen)
			{
				//printf("Initialising IObjectWatch\n");
			}

IObjectWatch::~IObjectWatch() {
}

void IObjectWatch::Sensors() {
	CheckObject();
}

void IObjectWatch::Actuators() {
}

void IObjectWatch::CheckObject() {
	const CCI_EPuckOmnidirectionalCameraSensor::SReadings& omnidirectional_camera_sensor_readings = omnidirectional_camera_sensor->GetReadings();
	std::vector<CCI_EPuckOmnidirectionalCameraSensor::SBlob*> blobs = omnidirectional_camera_sensor_readings.BlobList;

	//A big object can still block the vision of the camera
	printf("\n[Camera]\t");
	double distance = 1000;

	if(blobs.size() > 0)
	{
		for(CCI_EPuckOmnidirectionalCameraSensor::SBlob *blob : blobs)
		{
			std::ostringstream colour;
			colour << blob->Color;
			if (colour.str() == "white") {
				printf("Colour: %s, Area: %d, Distance: %.2f, Angle: %.2f\n",
					   colour.str().c_str(),
					   blob->Area,
					   blob->Distance,        //center of the robot to the blob (LED) in cm
					   ToDegrees(blob->Angle).UnsignedNormalize().GetValue());  //angle of the blob relative to the local coordinate of the robot
				heading = blob->Angle;
				distance = blob->Distance;
				if (objectSeen->size() == 0) {
					 printf("channel size1 before: %ld\n", objectSeen->size());
					 objectSeen->reg("environment", robochart::Optional<double>(distance));
					 printf("channel size1 after: %ld\n", objectSeen->size());
				}
				else {
					 objectSeen->clear();
					 printf("channel size4 before: %ld\n", objectSeen->size());
					 objectSeen->reg("environment", robochart::Optional<double>(distance));
					 printf("channel size4 after: %ld\n", objectSeen->size());
				}
				printf("\t\tobject seen: true");
				printf("\t\tobject distance: %f ", distance);
			}
			else {
				objectSeen->clear();
			}
		}
	}
}
