#ifndef ROBOCALC_IMOTIONCONTROL_H_
#define ROBOCALC_IMOTIONCONTROL_H_

#include "HardwareComponent.h"
#include "DataTypes.h"

class IMotionControl : public HardwareComponent {
public:
	IMotionControl();
	virtual ~IMotionControl();
	virtual void searchObject();
	virtual void moveToObject();
	virtual void closeInOnObject();
	virtual void pushObject();
	virtual void moveAroundObject();
	virtual void scanAndAlign();
	virtual void evade();

	virtual void Sensors();
	virtual void Actuators();

	void CheckObstacle();
	void ObstacleAvoidance();

public:
	double left_motor_speed, right_motor_speed;
	double linear_speed, angular_speed;
	double distance_turned, m_fWheelVelocity;
	int control_step;
	Direction dir;
	bool obstacle;

};


#endif
