#include "IMotionControl.h"

IMotionControl::IMotionControl
			()
			{
				//printf("Initialising IMotionControl\n");
				linear_speed = 0;
				angular_speed = 0;
				left_motor_speed = 0;
				right_motor_speed = 0;
				m_fWheelVelocity = 0;
				distance_turned = 0;
				control_step = 0;
				dir = Direction::no;
				obstacle = false;
			}

IMotionControl::~IMotionControl() {
}

void IMotionControl::searchObject() {
	if (control_step % 10 == 0) {
	   linear_speed = 0;
	   angular_speed = 4*7.5/5.3;
	   if (obstacle == true)
		   ObstacleAvoidance();
	}
	else {
	 /* move forward */
	   linear_speed = 7.5;
	   angular_speed = 0;
	   if (obstacle == true)
		   ObstacleAvoidance();
	}
}

void IMotionControl::moveToObject() {
	// Either turn left or right, depending on the desired heading
	if (heading.GetValue() <= -2*3.14/180)
	{
		linear_speed = 0;
		angular_speed = heading.GetValue()*10;
		if (obstacle == true)
		   ObstacleAvoidance();
	}
	else if (heading.GetValue() >= 2*3.14/180)
	{
		linear_speed = 0;
		angular_speed = heading.GetValue()*10;
		if (obstacle == true)
		   ObstacleAvoidance();
	}
	else
	{
		linear_speed = 7.5;
		angular_speed = 0;
		if (obstacle == true)
		   ObstacleAvoidance();
	}
}

void IMotionControl::closeInOnObject() {
	if (heading.GetValue() <= -2*3.14/180)
	{
		linear_speed = 0;
		angular_speed = heading.GetValue()*10;
	}
	else if (heading.GetValue() >= 2*3.14/180)
	{
		linear_speed = 0;
		angular_speed = heading.GetValue()*10;
	}
	else
	{
		linear_speed = 7.5;
		angular_speed = 0;
	}
}

void IMotionControl::pushObject() {
	linear_speed = 7.5;
	angular_speed = 0;
}

void IMotionControl::moveAroundObject() {
	linear_speed = -15;
	angular_speed = 1;
}

void IMotionControl::scanAndAlign() {
}

void IMotionControl::evade() {
	linear_speed = -15;
	angular_speed = 1;
}


void IMotionControl::Sensors() {
	CheckObstacle();
}

void IMotionControl::Actuators() {
	//reverse kinematics
	double lv = (2 * linear_speed - angular_speed * 5.3)/2;  //e-puck INTERWHEEL DISTANCE
	double rv = (2 * linear_speed + angular_speed * 5.3)/2;
	wheels_actuator->SetLinearVelocity(lv, rv);
}

void IMotionControl::CheckObstacle() {

	printf("\n[PROXIMITY]\t");

	const CCI_EPuckProximitySensor::TReadings& proximity_sensor_readings = proximity_sensor->GetReadings();

	for(CCI_EPuckProximitySensor::SReading reading : proximity_sensor_readings)
		printf("%.0f degrees: %.2f, ", ToDegrees(reading.Angle).GetValue(), reading.Value); //angle of the proximity sensor located in the e-puck and its value

	/* Get the highest reading in front of the robot, which corresponds to the closest object */
	// 8 proximity sensors in total around the body of e-puck
	m_fWheelVelocity = 7.5f;
	Real fMaxReadVal = proximity_sensor_readings[0].Value;
	UInt32 unMaxReadIdx = 0;
	if(fMaxReadVal < proximity_sensor_readings[1].Value) {
	  fMaxReadVal = proximity_sensor_readings[1].Value;
	  unMaxReadIdx = 1;
	}
	if(fMaxReadVal < proximity_sensor_readings[7].Value) {
	  fMaxReadVal = proximity_sensor_readings[7].Value;
	  unMaxReadIdx = 7;
	}
	if(fMaxReadVal < proximity_sensor_readings[6].Value) {
	  fMaxReadVal = proximity_sensor_readings[6].Value;
	  unMaxReadIdx = 6;
	}
	/* Do we have an obstacle in front? */
	if(fMaxReadVal > 0.0f) {
		obstacle = true;
		 if(unMaxReadIdx == 0 || unMaxReadIdx == 1) {
		   /* The obstacle is on the left*/
			 dir = Direction::left;
		 }
		 else if(unMaxReadIdx == 7 || unMaxReadIdx == 6) {
		   /* The obstacle is on the right*/
			 dir = Direction::right;
		 }
	}
	else {
		obstacle = false;
	}

	printf("\t\t obstacle: %d\n\n", obstacle);
}

void IMotionControl::ObstacleAvoidance() {
	 /* Yes, we do: avoid it */
	 if(dir == Direction::left) {
	   /* The obstacle is on the left, turn right */
		 linear_speed = 7.5;
		 angular_speed = -1.41;
	 }
	 else if(dir == Direction::right) {
	   /* The obstacle is on the right, turn left */
		 linear_speed = 7.5;
		 angular_speed = 1.41;
	 }
}

