#include "IGoalWatch.h"
/* 2D vector definition */
#include <argos3/core/utility/math/vector2.h>

IGoalWatch::IGoalWatch
			(std::shared_ptr<robochart::goalSeen_channel> goalSeen): goalSeen(goalSeen)
			{
				//printf("Initialising IGoalWatch\n");
			}

IGoalWatch::~IGoalWatch() {
}

void IGoalWatch::Sensors() {
	CheckGoal();
}

void IGoalWatch::Actuators() {
}

void IGoalWatch::CheckGoal() {
	printf("\n[LIGHT]\t\t");
    const CCI_EPuckLightSensor::TReadings& light_sensor_readings = light_sensor->GetReadings();
    CVector2 cAccumulatorLight;
	for(size_t i = 0; i < light_sensor_readings.size(); ++i) {
	   cAccumulatorLight += CVector2(light_sensor_readings[i].Value, light_sensor_readings[i].Angle);
	}
    printf("light intensity: %.2f", cAccumulatorLight.Length());

    if (cAccumulatorLight.Length() == 0) {
    	goalSeen->clear();  //the goal is occluded by the object
    	printf("\t\tgoal seen: false\n");
    }
    else {
		 if (goalSeen->size() == 0)       // the channel is always one place buffer
			 goalSeen->reg("environment");
		 else {
			 goalSeen->clear();           // this makes sure that the old one is deleted
			 goalSeen->reg("environment");
		 }
		 printf("\t\tgoal seen: true\n");
    }

}



