#ifndef ROBOCALC_MODULE_AGGREGATIONROBOT_H_
#define ROBOCALC_MODULE_AGGREGATIONROBOT_H_

#include "ePuck.h"
#include "MovementC.h"
#include "CommunicationC.h"
#include "ChannelTypes.h"

class AggregationRobot {
public:
	AggregationRobot() :
			AggregationRobot_ePuck(nullptr),
			AggregationRobot_MovementC(nullptr),
			AggregationRobot_CommunicationC(nullptr),
			report(std::make_shared<robochart::report_channel>("report")),
			ack(std::make_shared<robochart::ack_channel>("ack")),
			robots(std::make_shared<robochart::robots_channel>("robots")),
			obstacle(std::make_shared<robochart::obstacle_channel>("obstacle"))
			 {}
	virtual ~AggregationRobot() {}

	void Init();
	void Execute();

private:
	std::shared_ptr<robochart::report_channel> report;
	std::shared_ptr<robochart::ack_channel> ack;
	std::shared_ptr<robochart::robots_channel> robots;
	std::shared_ptr<robochart::obstacle_channel> obstacle;
	std::shared_ptr<ePuck> AggregationRobot_ePuck;
	std::shared_ptr<MovementC> AggregationRobot_MovementC;
	std::shared_ptr<CommunicationC> AggregationRobot_CommunicationC;
};

#endif
