#ifndef ROBOCALC_STATEMACHINES_COMMUNICATION_H_
#define ROBOCALC_STATEMACHINES_COMMUNICATION_H_

#include "RoboCalcAPI/State.h"
#include "ePuck.h"
#include "CommunicationC.h"
#include "Timer.h"
#include "Functions.h"
#include "DataTypes.h"
#include <assert.h>

#define SM_DEBUG

class Communication: public robochart::StateMachine
{
	public:
		std::shared_ptr<robochart::report_channel> report;
		std::shared_ptr<robochart::ack_channel> ack;
	public:
		std::shared_ptr<robochart::robots_channel> robots;
	public:
		std::shared_ptr<robochart::Timer> RCC;
		std::shared_ptr<ePuck> R_ePuck;
		std::shared_ptr<CommunicationC> C_CommunicationC;
	public:
		const   id;
		const   RC;
		  x;
		  y;
		std::set< > neighs;
	public:
		Communication(
				std::shared_ptr<ePuck> R_ePuck, 
				std::shared_ptr<CommunicationC> C_CommunicationC, 
				std::shared_ptr<robochart::report_channel> report,
				std::shared_ptr<robochart::ack_channel> ack,
				std::shared_ptr<robochart::robots_channel> robots);
		~Communication();
		int Initial();
		virtual void Execute();

	public:
		class i1 : public robochart::State 
		{
			public:
				i1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<CommunicationC> C_CommunicationC, std::shared_ptr<Communication> S_Communication) : State("i1"), R_ePuck(R_ePuck), C_CommunicationC(C_CommunicationC), S_Communication(S_Communication) 
				{
				}
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<CommunicationC> C_CommunicationC;
				std::shared_ptr<Communication> S_Communication;
		};
		class Broadcast : public robochart::State 
		{
			public:
				Broadcast(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<CommunicationC> C_CommunicationC, std::shared_ptr<Communication> S_Communication) : State("Broadcast"), R_ePuck(R_ePuck), C_CommunicationC(C_CommunicationC), S_Communication(S_Communication) 
				{
				}
				void Entry()
				{
					S_Communication->report->Clear();
					S_Communication->report->Reg("S_Communication");
				}
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<CommunicationC> C_CommunicationC;
				std::shared_ptr<Communication> S_Communication;
		};

};

#endif
