#include "Movement.h"  

Movement::Movement(
			std::shared_ptr<ePuck> R_ePuck, 
			std::shared_ptr<MovementC> C_MovementC, 
			std::shared_ptr<robochart::obstacle_channel> obstacle,
			std::shared_ptr<robochart::neighbours_channel> neighbours) :R_ePuck(R_ePuck), C_MovementC(C_MovementC), StateMachine("Movement"), obstacle(obstacle), neighbours(neighbours), lv(0), av(0), MB(0), alpha(NULL), n(NULL), p(Position::left), turned(false)
{
	MBC = std::make_shared<robochart::Timer>("MBC");
	

	std::shared_ptr<Movement> ptr(this);
	// instantiate states && add substates of machine
	std::shared_ptr<i1> S_Movement_i1 = std::make_shared<i1>(R_ePuck, C_MovementC, ptr);
	states.push_back(S_Movement_i1);
	std::shared_ptr<MovementAndAvoidance> S_Movement_MovementAndAvoidance = std::make_shared<MovementAndAvoidance>(R_ePuck, C_MovementC, ptr);
	states.push_back(S_Movement_MovementAndAvoidance);
	std::shared_ptr<Turning> S_Movement_Turning = std::make_shared<Turning>(R_ePuck, C_MovementC, ptr);
	states.push_back(S_Movement_Turning);

	std::shared_ptr<t1> S_Movement_t1 = std::make_shared<t1>(R_ePuck, C_MovementC, ptr, S_Movement_i1, S_Movement_MovementAndAvoidance);
	S_Movement_i1->transitions.push_back(S_Movement_t1);
	std::shared_ptr<t2> S_Movement_t2 = std::make_shared<t2>(R_ePuck, C_MovementC, ptr, S_Movement_MovementAndAvoidance, S_Movement_Turning);
	S_Movement_MovementAndAvoidance->transitions.push_back(S_Movement_t2);
	std::shared_ptr<t3> S_Movement_t3 = std::make_shared<t3>(R_ePuck, C_MovementC, ptr, S_Movement_Turning, S_Movement_MovementAndAvoidance);
	S_Movement_Turning->transitions.push_back(S_Movement_t3);

	stage = s_Enter;
}

Movement::~Movement() {
}

int Movement::Initial() {
	return 0;
}

void Movement::Execute() {
	MBC->IncCounter();
	StateMachine::Execute();
}
