#ifndef ROBOCALC_STATEMACHINES_MOVEMENT_H_
#define ROBOCALC_STATEMACHINES_MOVEMENT_H_

#include "RoboCalcAPI/State.h"
#include "ePuck.h"
#include "MovementC.h"
#include "Timer.h"
#include "Functions.h"
#include "DataTypes.h"
#include <assert.h>

#define SM_DEBUG

class Movement: public robochart::StateMachine
{
	public:
		std::shared_ptr<robochart::obstacle_channel> obstacle;
	public:
		std::shared_ptr<robochart::neighbours_channel> neighbours;
	public:
		std::shared_ptr<robochart::Timer> MBC;
		std::shared_ptr<ePuck> R_ePuck;
		std::shared_ptr<MovementC> C_MovementC;
	public:
		const double lv;
		const double av;
		const double MB;
		const   alpha;
		  n;
		Position p;
		bool turned;
	public:
		Movement(
				std::shared_ptr<ePuck> R_ePuck, 
				std::shared_ptr<MovementC> C_MovementC, 
				std::shared_ptr<robochart::obstacle_channel> obstacle,
				std::shared_ptr<robochart::neighbours_channel> neighbours);
		~Movement();
		int Initial();
		virtual void Execute();

	public:
		class i1 : public robochart::State 
		{
			public:
				i1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement) : State("i1"), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement) 
				{
				}
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<MovementC> C_MovementC;
				std::shared_ptr<Movement> S_Movement;
		};
		class MovementAndAvoidance : public robochart::State 
		{
			public:
				MovementAndAvoidance(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement) : State("MovementAndAvoidance"), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement) 
				{
						// instantiate states && add substates of machine
						std::shared_ptr<i1> MovementAndAvoidance_i1 = std::make_shared<i1>(R_ePuck, C_MovementC, S_Movement);
						states.push_back(MovementAndAvoidance_i1);
						std::shared_ptr<Move> MovementAndAvoidance_Move = std::make_shared<Move>(R_ePuck, C_MovementC, S_Movement);
						states.push_back(MovementAndAvoidance_Move);
						std::shared_ptr<Avoid> MovementAndAvoidance_Avoid = std::make_shared<Avoid>(R_ePuck, C_MovementC, S_Movement);
						states.push_back(MovementAndAvoidance_Avoid);
					
						std::shared_ptr<t1> MovementAndAvoidance_t1 = std::make_shared<t1>(R_ePuck, C_MovementC, S_Movement, MovementAndAvoidance_i1, MovementAndAvoidance_Move);
						MovementAndAvoidance_i1->transitions.push_back(MovementAndAvoidance_t1);
						std::shared_ptr<t2> MovementAndAvoidance_t2 = std::make_shared<t2>(R_ePuck, C_MovementC, S_Movement, MovementAndAvoidance_Move, MovementAndAvoidance_Avoid);
						MovementAndAvoidance_Move->transitions.push_back(MovementAndAvoidance_t2);
						std::shared_ptr<t3> MovementAndAvoidance_t3 = std::make_shared<t3>(R_ePuck, C_MovementC, S_Movement, MovementAndAvoidance_Avoid, MovementAndAvoidance_Move);
						MovementAndAvoidance_Avoid->transitions.push_back(MovementAndAvoidance_t3);
				}
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<MovementC> C_MovementC;
				std::shared_ptr<Movement> S_Movement;
			public:
				class i1 : public robochart::State 
				{
					public:
						i1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement) : State("i1"), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement) 
						{
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
				};
				~MovementAndAvoidance()
				{
				}
				int Initial()
				{
					return 0;
				}
				void Execute()
				{
					State::Execute();
				}
			public:
				class Move : public robochart::State 
				{
					public:
						Move(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement) : State("Move"), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement) 
						{
						}
						void Entry()
						{
							R_ePuck->move(S_Movement->lv, 0);
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
				};
			public:
				class Avoid : public robochart::State 
				{
					public:
						Avoid(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement) : State("Avoid"), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement) 
						{
						}
						void Entry()
						{
							if ((S_Movement->p == Position::left)) 
							{
								R_ePuck->move(0, S_Movement->av);
							}
							else 
							{
								R_ePuck->move(0, -S_Movement->av);
							}
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
				};
			public:
				class t1 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
					public:
						t1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition("S_Movement_MovementAndAvoidance_t1", src, tgt), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement)
						{}
				};
			public:
				class t2 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
						std::shared_ptr<robochart::obstacle_event> reg_obstacle_event;
					public:
						t2(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition("S_Movement_MovementAndAvoidance_t2", src, tgt), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement), reg_obstacle_event(nullptr)
						{}
						void Reg() {
							if (reg_obstacle_event == nullptr) {
								reg_obstacle_event = S_Movement->obstacle->Reg("Movement", robochart::Optional<Position>());
							}
						}
						bool Check() {
							Reg();
							if (S_Movement->obstacle->Check(reg_obstacle_event) == true) {
								#ifdef SM_DEBUG
									printf("TREATING EVENT obstacle\n");
								#endif
								S_Movement->p = std::get<0>(*reg_obstacle_event->GetOther().GetValue().lock()->GetParameters()).GetValue();
								ClearEvent();
								return true;
							}
							else {
								Cancel();
								return false;
							}
						}
						void Cancel() {
							if (reg_obstacle_event != nullptr) {
								S_Movement->obstacle->Cancel(reg_obstacle_event);
								reg_obstacle_event = nullptr;
							}
						}
						void ClearEvent() {
							S_Movement->obstacle->AcceptAndDelete(reg_obstacle_event);
							reg_obstacle_event = nullptr;
						}
				};
			public:
				class t3 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
					public:
						t3(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition("S_Movement_MovementAndAvoidance_t3", src, tgt), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement)
						{}
				};
		};
		class Turning : public robochart::State 
		{
			public:
				Turning(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement) : State("Turning"), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement) 
				{
						// instantiate states && add substates of machine
						std::shared_ptr<i1> Turning_i1 = std::make_shared<i1>(R_ePuck, C_MovementC, S_Movement);
						states.push_back(Turning_i1);
						std::shared_ptr<j1> Turning_j1 = std::make_shared<j1>(R_ePuck, C_MovementC, S_Movement);
						states.push_back(Turning_j1);
						std::shared_ptr<Turn180> Turning_Turn180 = std::make_shared<Turn180>(R_ePuck, C_MovementC, S_Movement);
						states.push_back(Turning_Turn180);
						std::shared_ptr<RandomTurn> Turning_RandomTurn = std::make_shared<RandomTurn>(R_ePuck, C_MovementC, S_Movement);
						states.push_back(Turning_RandomTurn);
						std::shared_ptr<f1> Turning_f1 = std::make_shared<f1>(R_ePuck, C_MovementC, S_Movement);
						states.push_back(Turning_f1);
					
						std::shared_ptr<t1> Turning_t1 = std::make_shared<t1>(R_ePuck, C_MovementC, S_Movement, Turning_i1, Turning_j1);
						Turning_i1->transitions.push_back(Turning_t1);
						std::shared_ptr<t2> Turning_t2 = std::make_shared<t2>(R_ePuck, C_MovementC, S_Movement, Turning_j1, Turning_Turn180);
						Turning_j1->transitions.push_back(Turning_t2);
						std::shared_ptr<t3> Turning_t3 = std::make_shared<t3>(R_ePuck, C_MovementC, S_Movement, Turning_j1, Turning_RandomTurn);
						Turning_j1->transitions.push_back(Turning_t3);
						std::shared_ptr<t4> Turning_t4 = std::make_shared<t4>(R_ePuck, C_MovementC, S_Movement, Turning_Turn180, Turning_f1);
						Turning_Turn180->transitions.push_back(Turning_t4);
						std::shared_ptr<t5> Turning_t5 = std::make_shared<t5>(R_ePuck, C_MovementC, S_Movement, Turning_RandomTurn, Turning_f1);
						Turning_RandomTurn->transitions.push_back(Turning_t5);
				}
				void Entry()
				{
					std::shared_ptr<robochart::neighbours_event> reg_neighbours_event;
					reg_neighbours_event = S_Movement->neighbours->Reg("S_Movement", robochart::Optional< >());
					bool neighbours_flag;
					neighbours_flag = S_Movement->neighbours->Check(reg_neighbours_event);
					assert(neighbours_flag && "error: neighbours is not available!");
					S_Movement->n = std::get<0>(*reg_neighbours_event->GetOther().GetValue().lock()->GetParameters()).GetValue();
					S_Movement->neighbours->AcceptAndDelete(reg_neighbours_event);
					reg_neighbours_event = nullptr;
					
					S_Movement->turned = false;
				}
			private:
				std::shared_ptr<ePuck> R_ePuck;
				std::shared_ptr<MovementC> C_MovementC;
				std::shared_ptr<Movement> S_Movement;
			public:
				class i1 : public robochart::State 
				{
					public:
						i1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement) : State("i1"), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement) 
						{
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
				};
				~Turning()
				{
				}
				int Initial()
				{
					return 0;
				}
				void Execute()
				{
					State::Execute();
				}
			public:
				class j1 : public robochart::State 
				{
					public:
						j1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement) : State("j1"), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement) 
						{
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
				};
			public:
				class Turn180 : public robochart::State 
				{
					public:
						Turn180(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement) : State("Turn180"), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement) 
						{
						}
						void Entry()
						{
							R_ePuck->move(0, S_Movement->av);
							S_Movement->n = abs(random());
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
				};
			public:
				class RandomTurn : public robochart::State 
				{
					public:
						RandomTurn(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement) : State("RandomTurn"), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement) 
						{
						}
						void Entry()
						{
							R_ePuck->move(0, S_Movement->av);
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
				};
			public:
				class f1 : public robochart::State 
				{
					public:
						f1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement) : State("f1"), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement) 
						{
						}
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
				};
			public:
				class t1 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
					public:
						t1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition("S_Movement_Turning_t1", src, tgt), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement)
						{}
				};
			public:
				class t2 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
					public:
						t2(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition("S_Movement_Turning_t2", src, tgt), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement)
						{}
						bool Condition() {
							if (S_Movement->n < S_Movement->alpha) {
								#ifdef SM_DEBUG
									printf("Condition of transition S_Movement_Turning_t2 is true\n");
								#endif
								return true;
							}
							else {
								#ifdef SM_DEBUG
									printf("Condition of transition S_Movement_Turning_t2 is false\n");
								#endif
								return false;
							}
						}
				};
			public:
				class t3 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
					public:
						t3(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition("S_Movement_Turning_t3", src, tgt), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement)
						{}
						bool Condition() {
							if (S_Movement->n > S_Movement->alpha) {
								#ifdef SM_DEBUG
									printf("Condition of transition S_Movement_Turning_t3 is true\n");
								#endif
								return true;
							}
							else {
								#ifdef SM_DEBUG
									printf("Condition of transition S_Movement_Turning_t3 is false\n");
								#endif
								return false;
							}
						}
				};
			public:
				class t4 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
					public:
						t4(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition("S_Movement_Turning_t4", src, tgt), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement)
						{}
						void Action() {
							S_Movement->turned = true;
						}
				};
			public:
				class t5 : public robochart::Transition {
					private:
						std::shared_ptr<ePuck> R_ePuck;
						std::shared_ptr<MovementC> C_MovementC;
						std::shared_ptr<Movement> S_Movement;
					public:
						t5(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
						   robochart::Transition("S_Movement_Turning_t5", src, tgt), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement)
						{}
						void Action() {
							S_Movement->turned = true;
						}
				};
		};

		public:
			class t1 : public robochart::Transition {
				private:
					std::shared_ptr<ePuck> R_ePuck;
					std::shared_ptr<MovementC> C_MovementC;
					std::shared_ptr<Movement> S_Movement;
				public:
					t1(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
					   robochart::Transition("S_Movement_t1", src, tgt), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement)
					{}
			};
		public:
			class t2 : public robochart::Transition {
				private:
					std::shared_ptr<ePuck> R_ePuck;
					std::shared_ptr<MovementC> C_MovementC;
					std::shared_ptr<Movement> S_Movement;
				public:
					t2(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
					   robochart::Transition("S_Movement_t2", src, tgt), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement)
					{}
					bool Condition() {
						if (S_Movement->MBC->GetCounter() > S_Movement->MB) {
							#ifdef SM_DEBUG
								printf("Condition of transition S_Movement_t2 is true\n");
							#endif
							return true;
						}
						else {
							#ifdef SM_DEBUG
								printf("Condition of transition S_Movement_t2 is false\n");
							#endif
							return false;
						}
					}
			};
		public:
			class t3 : public robochart::Transition {
				private:
					std::shared_ptr<ePuck> R_ePuck;
					std::shared_ptr<MovementC> C_MovementC;
					std::shared_ptr<Movement> S_Movement;
				public:
					t3(std::shared_ptr<ePuck> R_ePuck, std::shared_ptr<MovementC> C_MovementC, std::shared_ptr<Movement> S_Movement, std::weak_ptr<robochart::State> src, std::weak_ptr<robochart::State> tgt):
					   robochart::Transition("S_Movement_t3", src, tgt), R_ePuck(R_ePuck), C_MovementC(C_MovementC), S_Movement(S_Movement)
					{}
					bool Condition() {
						if (S_Movement->turned == true) {
							#ifdef SM_DEBUG
								printf("Condition of transition S_Movement_t3 is true\n");
							#endif
							return true;
						}
						else {
							#ifdef SM_DEBUG
								printf("Condition of transition S_Movement_t3 is false\n");
							#endif
							return false;
						}
					}
			};
};

#endif
