#include "Communication.h"  

Communication::Communication(
			std::shared_ptr<ePuck> R_ePuck, 
			std::shared_ptr<CommunicationC> C_CommunicationC, 
			std::shared_ptr<robochart::report_channel> report,
			std::shared_ptr<robochart::ack_channel> ack,
			std::shared_ptr<robochart::robots_channel> robots) :R_ePuck(R_ePuck), C_CommunicationC(C_CommunicationC), StateMachine("Communication"), report(report), ack(ack), robots(robots), id(NULL), RC(NULL), x(NULL), y(NULL), neighs(std::set< >())
{
	RCC = std::make_shared<robochart::Timer>("RCC");
	

	std::shared_ptr<Communication> ptr(this);
	// instantiate states && add substates of machine
	std::shared_ptr<i1> S_Communication_i1 = std::make_shared<i1>(R_ePuck, C_CommunicationC, ptr);
	states.push_back(S_Communication_i1);
	std::shared_ptr<Broadcast> S_Communication_Broadcast = std::make_shared<Broadcast>(R_ePuck, C_CommunicationC, ptr);
	states.push_back(S_Communication_Broadcast);


	stage = s_Enter;
}

Communication::~Communication() {
}

int Communication::Initial() {
	return 0;
}

void Communication::Execute() {
	RCC->IncCounter();
	StateMachine::Execute();
}
