#include "AggregationRobot.h"
#include "Movement.h"
#include "Communication.h"

void AggregationRobot::Init() {
	AggregationRobot_ePuck = std::make_shared<ePuck> (obstacle, report, ack);
	AggregationRobot_MovementC = std::make_shared<MovementC> (AggregationRobot_ePuck, obstacle, neighbours);
	std::shared_ptr<Movement> MovementC_Movement = std::make_shared<Movement>(AggregationRobot_ePuck, AggregationRobot_MovementC, obstacle, neighbours);
	AggregationRobot_MovementC->stm = MovementC_Movement;
	AggregationRobot_CommunicationC = std::make_shared<CommunicationC> (AggregationRobot_ePuck, report, ack, robots);
	std::shared_ptr<Communication> CommunicationC_Communication = std::make_shared<Communication>(AggregationRobot_ePuck, AggregationRobot_CommunicationC, report, ack, robots);
	AggregationRobot_CommunicationC->stm = CommunicationC_Communication;
}

void AggregationRobot::Execute() {
	AggregationRobot_ePuck->Sensors();
	AggregationRobot_MovementC->Execute();AggregationRobot_CommunicationC->Execute();
	AggregationRobot_ePuck->Actuators();
}

