public class BoundedBuffer
{
  private int buffer[];
  private int first;
  private int last;
  private int numberInBuffer = 0;
  private int size;

  public BoundedBuffer(int length)
  {
    size = length;
    buffer = new int[size];
    last = 0;
    first = 0;
  };

  public synchronized void put(int item) throws InterruptedException
  {
      if (numberInBuffer == size) {
        wait();
      };
      last = (last + 1) % size ; // % is modulus
      numberInBuffer++;
      buffer[last] = item;
      notify();
  };


  public synchronized int get() throws InterruptedException
  {
      if (numberInBuffer == 0) {
        wait();
      };
      first = (first + 1) % size ; // % is modulus
      numberInBuffer--;
      notify();
      return buffer[first];
  };
}
