with semaphore_package; use semaphore_package;
separate (main)
package body buffer is
  SIZE : constant natural := 32;
  type buffer_range is mod SIZE;
  BUF : array (buffer_range) of integer;
  top, base : buffer_range := 0;

  mutex : semaphore; -- default is 1
  item_available : semaphore(0);
  space_available : semaphore(Initial => Size);

  procedure append (I : integer) is
  begin
    wait(space_available);
    wait(mutex);
      BUF(top) := I;
      top := top+1;
    signal(mutex);
    signal(item_available);
  end append;

  procedure take (I : out integer) is
  begin
    wait(item_available);
    wait(mutex);
      I := BUF(base);
      base := base+1;
    signal(mutex);
    signal(space_available);
  end take;
end buffer;
