#include "mutex.h"

#define BUFF_SIZE 10

typedef struct {
  pthread_mutex_t mutex;
  pthread_cond_t buffer_not_full;
  pthread_cond_t buffer_not_empty;
  int count, first, last;
  int buf[BUFF_SIZE];
  } buffer;

int append(int item, buffer *B ) {
  PTHREAD_MUTEX_LOCK(&B->mutex);
  while(B->count == BUFF_SIZE)
    PTHREAD_COND_WAIT(&B->buffer_not_full, &B->mutex);
  /* put data in the buffer and update count and last */
  PTHREAD_COND_SIGNAL(&B->buffer_not_empty);
  PTHREAD_MUTEX_UNLOCK(&B->mutex);
  return 0;
}

int take(int *item, buffer *B ) {
  PTHREAD_MUTEX_LOCK(&B->mutex);
  while(B->count == 0)
    PTHREAD_COND_WAIT(&B->buffer_not_empty, &B->mutex);
  /* get data from the buffer and update count and first */
  PTHREAD_COND_SIGNAL(&B->buffer_not_full);
  PTHREAD_MUTEX_UNLOCK(&B->mutex);
  return 0;
}
