procedure buffer is

  type data_item is new integer;
  
  buffer_size : constant integer := 10;
  type index is mod buffer_size ;
  subtype count is natural range 0 .. buffer_size;
  type buffer is array (index) of data_item;

  protected type bounded_buffer is
    entry get(item: out data_item);
    entry put(item: in data_item);
  private
    first : index := index'first;
    last : index := index'last;
    number_in_buffer : count := 0;
    buf : buffer;
  end bounded_buffer;

  my_buffer : bounded_buffer;

  protected body bounded_buffer is

    entry get(item: out data_item)
      when number_in_buffer /= 0 is
    begin
      item := buf(first);
      first := first + 1; -- mod types type around
      number_in_buffer := number_in_buffer - 1;
    end get;

    entry put(item: in data_item)
      when number_in_buffer /= buffer_size is
    begin
      last := last + 1; -- mod types type around
      buf(last) := item;
      number_in_buffer := number_in_buffer + 1;
     end put;

  end bounded_buffer;

begin
  null;
end buffer;

