public class SemaphoreResourceManager
{

  private final int maxResources = 15;
  protected QuantitySemaphore resourcesFree;

  public SemaphoreResourceManager()
  {
    resourcesFree = new QuantitySemaphore(maxResources);
  }

  public void allocate(int size) throws 
                      TooManyResourcesRequested, InterruptedException
    
  {
    System.out.println("allocate called need " + size);
    if(size > maxResources) throw new 
                      TooManyResourcesRequested();
    resourcesFree.wait(size);
  }

  public void deallocate(int size)
  {
    System.out.println("deallocate releasing " + size);
    resourcesFree.signal(size); 
  }
}

