public class ResourceManager
{

  private final int maxResources = 15;
  protected int resourcesFree;

  public ResourceManager()
  {
    resourcesFree = maxResources;
  }

  public synchronized void allocate(int size) throws 
                      TooManyResourcesRequested, InterruptedException
    
  {
    boolean got = false;
    System.out.println("allocate called need " + size);

    if(size > maxResources) throw new 
                      TooManyResourcesRequested();
    while(size > resourcesFree) {
       System.out.println("allocate waiting: need " + size + " available " +  resourcesFree);
       wait();
    }
    resourcesFree = resourcesFree - size;
  }

  public synchronized void deallocate(int size)
    // assumes FIFO scheduling
  {
    System.out.println("deallocate releasing " + size);
    resourcesFree = resourcesFree + size;  
    System.out.println("resources left " + resourcesFree);
    notifyAll(); 
  }
}

