public class ReadersWriters2
{

  private int readers = 0;
  private int waitingReaders = 0;
  private int waitingWriters = 0;
  private boolean writing = false;
  
  ConditionVariable OkToRead = new ConditionVariable();
  ConditionVariable OkToWrite = new ConditionVariable();
  
  public void startWrite() throws InterruptedException
  {
    System.out.println("Start Write called ");
    synchronized(OkToWrite) // get lock on condition variable
    {
      //System.out.println("StartWrite got OkTOWrite Lock ");
      synchronized(this) // get monitor lock
      {
        //System.out.println("StartWrite got this Lock ");
        if(writing | readers > 0 | waitingReaders > 0) {
          waitingWriters++;
          OkToWrite.wantToSleep = true;
        } else  {
          writing = true;
          OkToWrite.wantToSleep = false;
        }
      } //give up monitor lock
      if(OkToWrite.wantToSleep) {
        System.out.println("sleeping for Write lock ");
        OkToWrite.wait();
      }
    }    
  }
  
  public void stopWrite()
  {
  System.out.println("StopWrite Called ");

    synchronized(OkToRead) 

    {
      //System.out.println("StopWrite got OkToRead ");
      synchronized(OkToWrite)
      {
        //System.out.println("StopWrite got OkToWrite ");
        synchronized(this) 
        {
          //System.out.println("Inner StopWrite Called ");

          if(waitingReaders > 0) {
            writing = false;
            readers = waitingReaders;
            waitingReaders = 0;
            OkToRead.notifyAll();
          } else if(waitingWriters > 0) {
            waitingWriters--;
            OkToWrite.notify();
          } else writing = false;
        }
      }
    }      
  }
  
  public synchronized void startRead() throws InterruptedException
  {
    synchronized(OkToRead) {
      System.out.println("startRead got OkToRead lock ");
      synchronized(this)
      {
        //System.out.println("startRead got thislock ");
        if(writing) {
          waitingReaders++;
          OkToRead.wantToSleep = true;
        } else {
          readers++;
          OkToRead.wantToSleep = false;
        } 
        //System.out.println("startRead about to give up this lock");
      }
      if(OkToRead.wantToSleep) {
        
        System.out.println("Start Read Sleeping ");
        OkToRead.wait(); 
      } 
    }       
  }
  
  public synchronized void stopRead()
  {
    System.out.println("stopRead called");
    synchronized(OkToWrite)
    {
      synchronized(this) 
      {
        //System.out.println("stopRead got this lock");
        readers--;
        if(readers == 0 & waitingWriters > 0) {
          waitingWriters--;
          writing = true;
          OkToWrite.notify();
        }
      }
    }
  }  
}

