public class NewBoundedBuffer 
{
  private int buffer[];
  private int first;
  private int last;
  private int numberInBuffer = 0;
  private int size;

  ConditionVariable bufferNotFull, bufferNotEmpty;
  
  public NewBoundedBuffer(int length)
  {
    size = length;
    buffer = new int[size];
    last = 0;
    first = 0;
    bufferNotFull = new ConditionVariable();
    bufferNotEmpty = new ConditionVariable();
  };
  
  public void put(int item) throws InterruptedException
  {
    synchronized(bufferNotFull) {
      System.out.println("put trying for this");
      synchronized(this) {
        if (numberInBuffer == size) {
          bufferNotFull.wantToSleep = true;
        } else { 
          bufferNotFull.wantToSleep = false;
        }
      }
      if(bufferNotFull.wantToSleep) {
        System.out.println("waiting buffer Not Full");
        bufferNotFull.wait();
      }
    }
    synchronized(bufferNotEmpty) {
      System.out.println("put trying for this again");
      synchronized(this) {
        last = (last + 1) % size ; // % is modulus
        numberInBuffer++;
        buffer[last] = item; 
        System.out.println("signalling bufferNotEmpty");
        bufferNotEmpty.notify();
      }
    }
  };
  
   
  public synchronized int get() throws InterruptedException
  {
    int I;
    synchronized(bufferNotEmpty) {
      System.out.println("get trying for this");
      synchronized(this) {
        if (numberInBuffer == 0) {
          bufferNotEmpty.wantToSleep = true;
        } else {
          bufferNotEmpty.wantToSleep = false;
        }
      }
      if(bufferNotEmpty.wantToSleep) {
        System.out.println("waiting buffer Not empty");
        bufferNotEmpty.wait();
      }
    }
    synchronized(bufferNotFull) {
      System.out.println("get trying for this again");
      synchronized(this) {
        first = (first + 1) % size ; // % is modulus
        numberInBuffer--;
        System.out.println("signalling bufferfull");
        bufferNotFull.notify();
        return buffer[first];
      };
    }
  };
}

