public class Event
{
  private int highPriorityWaiting;
  private int lowPriorityWaiting;
  private ConditionVariable highWaiter;
  private ConditionVariable lowWaiter;

  public Event()
  {
    highPriorityWaiting = 0;
    lowPriorityWaiting = 0;
    highWaiter = new ConditionVariable();
    lowWaiter = new ConditionVariable();
  }

  public  void highPriorityWait()
  {
    synchronized(highWaiter) {
      synchronized(this) {
        highPriorityWaiting++;
      }
      try {
        highWaiter.wait();
      } catch(Exception E) {};
    }
  };

  public synchronized void lowPriorityWait()
  {
    synchronized(lowWaiter) {
      synchronized(this) {
        lowPriorityWaiting++;
      }
      try {
        lowWaiter.wait();
      } catch(Exception E) {};
    }
  };
  public synchronized void signalEvent()
  {
    synchronized(highWaiter) {
      synchronized(lowWaiter) {
        synchronized(this) {
            if(highPriorityWaiting > 0) {
              highWaiter.notify();
              highPriorityWaiting--;
            } else if (lowPriorityWaiting > 0) {
              lowWaiter.notify();
              lowPriorityWaiting--;
            }
        }
      }
    }
    
  };
}
