
#include <pthread.h>

pthread_attr_t attributes;
pthread_t xp, yp, zp;

typedef enum {xplane, yplane, zplane} dimension;

int new_setting(dimension D);
void move_arm(dimension D, int P);

void controller(dimension *dim)
{
  int position, setting;

  position = 0;
  while (1) {
    move_arm(*dim, position);
    setting = new_setting(*dim);
    position = position + setting;
  }
  /* note, no call to pthread_exit, process does not
     terminate */
}

#include <stdlib.h>
int main() {
  dimension X, Y, Z;
  void *result;

  X = xplane,
  Y = yplane;
  Z = zplane;
  if(pthread_attr_init(&attributes) != 0)
    /* set default attributes */
    exit(EXIT_FAILURE);
  if(pthread_create(&xp, &attributes,
                    (void *)controller, &X) != 0)
    exit(EXIT_FAILURE);
  if(pthread_create(&yp, &attributes,
                    (void *)controller, &Y) != 0)
    exit(EXIT_FAILURE);
  if(pthread_create(&zp, &attributes,
                    (void *)controller, &Z) != 0)
    exit(EXIT_FAILURE);
  pthread_join(xp, (void **)&result);
  /* need to block main program */

  exit(EXIT_FAILURE);
  /* error exit, the program should not terminate */

}
