#include <stdio.h>
#include "queue2.h"

  struct queue_node_t {
      element contents;
      struct queue_node_t *next;
  };

  struct queue_t { 
    struct queue_node_t *front;
    struct queue_node_t *back;
  };

  queue_ptr_t create()
  {
    queue_ptr_t Q;

    Q = (struct queue_t *)malloc(sizeof(struct queue_t));
    Q->front = NULL;
    Q->back = NULL;
    return Q;
  }
  
  int empty(queue_ptr_t Q)
  {
    return Q->front == NULL;
  }
  
  void insertE(queue_ptr_t Q, element E)
  {
    struct queue_node_t *new_node;

    new_node = (struct queue_node_t *) malloc(sizeof(struct queue_node_t));
    new_node->contents = E;
    new_node->next = NULL;
    if(empty) {
      Q->front = new_node;
    } else {
      Q->back->next = new_node;
    };
    Q->back = new_node;
  }
  
  void removeE(queue_ptr_t Q, element *E)
  {
    struct queue_node_t *old_node;

    old_node = Q->front;
    *E = old_node->contents;
    Q->front = Q->front->next;
    if(Q->front == NULL) {
      Q->back = NULL;
    }
    free(old_node);
  }
