#include <stdio.h>
#include "queue.h"

  struct queue_node_t {
      element contents;
      struct queue_node_t *next;
  };

  struct queue_t { 
    struct queue_node_t *front;
    struct queue_node_t *back;
  } *Q;

  void create()
  {
    Q = (struct queue_t *)malloc(sizeof(struct queue_t));
    Q->front = NULL;
    Q->back = NULL;
  }
  
  int empty()
  {
    return(Q->front == NULL);
  }
  
  void insertE(element E)
  {
    struct queue_node_t *new_node;

    new_node = (struct queue_node_t *) malloc(sizeof(struct queue_node_t));
    new_node->contents = E;
    new_node->next = NULL;
    if(empty) {
      Q->front = new_node;
    } else {
      Q->back->next = new_node;
    };
    Q->back = new_node;
  }
  
  void removeE(element *E)
  {
    struct queue_node_t *old_node;

    old_node = Q->front;
    *E = old_node->contents;
    Q->front = Q->front->next;
    if(Q->front == NULL) {
      Q->back = NULL;
    }
    free(old_node);
  }
