with Ada.unchecked_deallocation;
package body queuemod is

 type queue_node_t;
  type queue_node_ptr_t is access queue_node_t;

  type queue_node_t is
    record
      contents : element;
      next : queue_node_ptr_t;
    end record;

  type queue_t is 
    record
      front : queue_node_ptr_t;
      back : queue_node_ptr_t;
    end record;

  type queue_ptr_t is access queue_t;

  Q : queue_ptr_t; 

  procedure free is new Ada.unchecked_deallocation(queue_node_t, queue_node_ptr_t);
  
  
  PROCEDURE create is
  BEGIN
    Q := new queue_t;
    Q.front := null;
    Q.back := null;
  END create;
  
  function empty return BOOLEAN is
  BEGIN
    RETURN Q.front = null;
  END empty;
  
  PROCEDURE insert(E : element) is
    new_node : queue_node_ptr_t;
  BEGIN
    new_node := new queue_node_t;
    new_node.contents := E;
    new_node.next := null;
    IF empty THEN
      Q.front := new_node;
    ELSE
      Q.back.next := new_node;
    END if;
    Q.back := new_node;
  END insert;
  
  PROCEDURE remove(E : out element) is
    old_node : queue_node_ptr_t;
  BEGIN
    old_node := Q.front;
    E := old_node.contents;
    Q.front := Q.front.next;
    IF Q.front = null THEN
      Q.back := null;
    END if;
   free(old_node);
  END remove;
end queuemod;
