generic
  size : natural := 32;
  type element is private;
package buffer_template is
  type buffer is limited private;
  procedure create(B : in out buffer);
  function empty(B : buffer) return boolean;
  procedure place(B : in out buffer; E : element);
  procedure take(B : in out buffer; E : out element);
private
  subtype buffer_range is natural range  0..size-1;
  type buff is array(buffer_range) of element;
  type buffer is
    record
      BF : buff;
      top : buffer_range := 0;
      base: buffer_range := 0;
    end record;
end buffer_template;
