with Ada.Numerics.Generic_Elementary_Functions;

procedure Quadratic (A, B, C : in Float;
                    R1, R2 : out Float;
                     OK : out Boolean) is
  package Numerics is new Ada.Numerics.Generic_Elementary_Functions(Float);		     
  Z : Float;
  use Numerics;
begin
  Z:= B*B - 4.0*A*C;
  if Z < 0.0 or A = 0.0 then
    OK:= False;
    R1:= 0.0;     -- arbitrary values
    R2:= 0.0;
    return;       -- return from a procedure before
                  -- reaching logical end
  end if;
  OK:= True;
  R1:= (-B + Sqrt(Z)) / (2.0*A); 
  R2:= (-B - Sqrt(Z)) / (2.0*A);
end Quadratic;
