#include "../../POSIX/sig.h" 
#include "../../POSIX/time.h"
#include "../../POSIX/pthread.h"

timer_t timer; /* timer shared between monitor and server */

struct timespec deadline ;
struct timespec zero;

struct itimerspec alarm_time, old_alarm;

struct sigevent s; 


void server(timer_t *watchdog) 
{
  /* perform required service */
  TIMER_DELETE(*watchdog);
}


void watchdog_handler(int signum, siginfo_t *data, void *extra)
{
  /* SIG_ALRM handler */

  /* server is late */
  /* undertake some recovery */
}

void monitor()
{
  pthread_attr_t attributes;
  pthread_t serve;


  sigset_t mask, omask;
  struct sigaction sa, osa;
  int local_mode;

  sigemptyset(&mask);
  sigaddset(&mask, SIGALRM);

  sa.sa_flags = SA_SIGINFO;
  sa.sa_mask = mask;
  sa.sa_sigaction = &watchdog_handler;

  sigaction(SIGALRM, &sa, &osa); /* assign handler */


  alarm_time.it_value = deadline;
  alarm_time.it_interval = zero; /* one shot timer */

  s.sigev_notify = SIGEV_SIGNAL;
  s.sigev_signo = SIGALRM;

  timer_create(CLOCK_REALTIME, &s, &timer);

  timer_settime(timer, TIMER_ABSTIME, &alarm_time, &old_alarm);

  pthread_attr_init(&attributes);
  pthread_create(&serve, &attributes, (void *)server, &timer);

}
