procedure sporadic is

  protected sporadic_controller is
    procedure interrupt; -- mapped onto interrupt
    entry wait_for_next_interrupt;
  private
    call_outstanding : boolean := false;
  end sporadic_controller;

  protected body sporadic_controller is

    procedure interrupt is
    begin
      call_outstanding := true;
    end interrupt;

    entry wait_for_next_interrupt when call_outstanding is
    begin
      call_outstanding := false;
    end wait_for_next_interrupt;
  end sporadic_controller;

  task sporadic_T;

  task body sporadic_T is
  begin
    loop
     sporadic_controller.wait_for_next_interrupt;
      -- action
    end loop;
  end sporadic_T;
begin
  null;
end;
