#include "../../POSIX//sig.h"
#include "../../POSIX/time.h"
#include "../../POSIX/pthread.h"
void periodic_thread() /* destined to be the thread */
{
  int signum;                 /* signal caught */
  sigset_t set;               /* signals to be waited for */
  struct sigevent sig;        /* signal information */
  timer_t periodic_timer;           /* timer for a periodic thread */
  struct itimerspec required, old;  /* timer details */
  struct timespec first, period;    /* start and repetition */
  long Thread_Period = 10000;    /* ***** **/

  /* set up signal interface */
  sig.sigev_notify = SIGEV_SIGNAL;
  sig.sigev_signo = SIGRTMIN; /* for example */
  /* allow, for example, 1 sec from now for system initialisation */
  clock_gettime(CLOCK_REALTIME, &first);    /* get current time */
  first.tv_sec = first.tv_sec + 1;     
  period.tv_sec = 0;                     /* set repetition value to */
  period.tv_nsec = Thread_Period;         /* period */
  required.it_value = first;            /* initialise timer details */
  required.it_interval = period;
  timer_create(CLOCK_REALTIME, &sig, &periodic_timer); 
  sigemptyset(&set);               /* initialise signal set to null */
  sigaddset(&set, SIGRTMIN);       /* only allow timer */
  timer_settime(periodic_timer, 0, &required, &old);

  /* enter periodic loop */
  while(1) {
    sigwait(&set, &signum);
    /* code to be executed each period here */
  }      
}


int init() 
{
  pthread_attr_t attributes;      /* thread attributes */
  pthread_t PT;                   /* thread pointer */

  pthread_attr_init(&attributes); /* default attributes */
  pthread_create(&PT, &attributes, 
                 (void *) periodic_thread, (void *)0);
}
