with Ada.Real_Time; use Ada.Real_Time;
procedure periodic is

  task periodic_t;
  
  task body periodic_t is
    next_release : time;
    next_deadline : time;
    release_interval : constant time_span := milliseconds(1000);
    deadline : constant time_span := milliseconds(800);
begin
    -- read clock and calculate the next
    -- release time (next_release) and
    -- next deadline (next_deadline)
    loop
      select
        delay until next_deadline;
        -- deadline overrun detected here
        -- perform recovery
      then abort
        -- sample data (for example) or
        -- calculate and send a control signal
	null;
      end select;
      delay until next_release;
      next_release := next_release + release_interval;
      next_deadline := next_release + deadline;
    end loop;
  end periodic_t;
begin
  null;
end;  
