package body resource_manager is

  task manager is
    entry sign_in(size : instances_of_resource);
    entry allocate(instances_of_resource); -- entry family
    entry free(size : instances_of_resource);
  end manager;

  procedure allocate(size : instances_of_resource) is
  begin
    manager.sign_in(size);  -- size is a parameter
    manager.allocate(size); -- size is an index into a family
  end allocate;

  procedure free(size : instances_of_resource) is
  begin
    manager.free(size);
  end free;

  task body manager is
     pending : array(instances_of_resource) of
       natural := (others => 0);
     resource_free : resource_range := resource_range'last;
     Allocated : Boolean;
  begin
    loop
      select
        accept sign_in(size : instances_of_resource) do
          pending(size) := pending(size) + 1;
        end sign_in;
      or
        accept free(size : instances_of_resource) do
          resource_free := resource_free + size;    
        end free;
      end select;
      loop -- main loop
        loop -- accept any pending Sign-In or Frees, do not wait
          select
            accept sign_in(size : instances_of_resource) do
              pending(size) := pending(size) + 1;
            end sign_in;
          or
            accept free(size : instances_of_resource) do
              resource_free := resource_free + size;
            end free;
          else
            exit;
          end select;
        end loop;
        Allocated := False;

        for request in reverse instances_of_resource loop
          if pending(request) > 0 and resource_free >= request then
            accept allocate(request);
            pending(request) := pending(request) - 1;
            resource_free := resource_free - request;
            Allocated := True;
            exit; --loop to accept new Sign-Ins
          end if;
        end loop;
        exit when not Allocated;
      end loop;
    end loop;
  end manager;
end resource_manager;
