procedure protected_resource is
  type resource is new integer;

  type request_range is range 1.. 10;

  protected resource_controller is
    entry request(R : out resource; amount : request_range);
    procedure free(R : resource; amount : request_range);
  private
    entry assign(R : out resource; amount : request_range);
    freed : request_range := request_range'last;
    new_resources_released : boolean := false;
    to_try : Natural := 0;
  end resource_controller;

  protected body resource_controller is
    entry request(R : out resource; amount : request_range) 
        when freed > 0 is
    begin
      if amount <= freed then
        freed := freed - amount; 
        -- allocate
      else
        requeue assign;
      end if;
    end request;

    entry assign(R : out resource; amount : request_range)
      when new_resources_released is
    begin
      to_try := to_try - 1;
      if to_try = 0 then
        new_resources_released := false;
      end if;
      if amount <= freed then
        freed := freed - amount; 
        -- allocate
      else
        requeue assign;
      end if;
    end assign;

    procedure free(R : resource; amount : request_range) is
    begin
      freed := freed + amount;  
      -- free resources
      if assign'count > 0 then
        to_try := assign'count;
        new_resources_released := true;
      end if;
    end free;
  end resource_controller;

begin
  null;
end;
