procedure network_router is

  type Line_id is (Line_A, Line_B, Line_C);
  type Line_Status is array (Line_Id) of Boolean;

  task type Line_Controller(Id : Line_id) is
    entry Request;
  end Line_Controller;

  protected Router is
    entry Send;  --  same parameter profile as Request
    procedure overloaded(Line : Line_Id);
    procedure clear(Line : Line_Id);
  private
    OK : Line_Status := (others => true);
  end Router;

  LA : Line_Controller(Line_A);
  LB : Line_Controller(Line_B);
  LC : Line_Controller(Line_C);
 
  task body Line_Controller is 
  begin
    loop
      select
        accept request do
          -- service request
	  null;
        end request;
      or
        terminate;
      end select;
      -- housekeeping including possibly
      Router.overloaded(Id);
      -- or
      Router.clear(Id);
    end loop;
  end line_controller;

  protected body Router is

    entry Send when OK(Line_A) or OK(Line_B) or OK(Line_C) is
    begin
      if OK(Line_A) then
        requeue LA.request with abort;
      elsif OK(Line_B) then
        requeue LB.request with abort;
      else
        requeue LC.request with abort;
      end if;
    end Send;

    procedure overloaded(Line : Line_ID) is
    begin
      OK(Line) := false;
    end overloaded;

    procedure clear(Line : Line_ID) is
    begin
      OK(Line) := true;
    end clear;
  end Router;
begin
  null;
end;
