public class ResourceManager
{

  private final int maxResources = 10;
  private int resourcesFree;

  public ResourceManager()
  {
    resourcesFree = maxResources;
  }

  public synchronized void allocate(int size) throws 
                      IntegerConstraintError, InterruptedException
    // see  Section ref{Java:exceptions} for definition of IntegerConstraintError
  {
    if(size > maxResources) throw new 
                      IntegerConstraintError(1, maxResources, size);
    while(size < resourcesFree) wait();
    resourcesFree = resourcesFree - size;   
  }

  public synchronized void free(int size)
  {
    resourcesFree = resourcesFree + size;  
    notifyAll();  
  }
}
