#define SIGRTMIN 12
#define SIG_UNBLOCK 1
#define SIG_BLOCK 2
union sigval {
  int sival_int;
  int *sival_ptr;
};

typedef struct {
  int si_signo;
  int si_code;
  union sigval si_value;
} siginfo_t;

typedef int sigset_t;

struct sigaction {
  void (* sa_handler) (int signum) ;
  void (*sa_sigaction) (int signum, siginfo_t *data, void *extra) ;
  sigset_t sa_mask;
  int sa_flags;
};

struct sigevent {
  int sigev_notify;
  int si_signo;
  union sigval si_value;
};

int sigaction(int sig, const struct sigaction *reaction,
              struct sigaction *old_reaction);

int sigprocmask(int op, const sigset_t *set, sigset_t *oset);

int sigemptyset( sigset_t *s);

int sigfillset(sigset_t *s);
int sigaddset(sigset_t *s, int signum);
int sigdelset(sigset_t *s, int signum);
int sigismember(sigset_t *s, int signum); /* returns 1 if a member */

/* All the above functions returns 0 if successful, otherwise -1. */
/* When an error condition is returned by any of the above functions, */
/* a shared variable errno contains the reason for the error */
