#include "sig.h"


#define MODE_A 1
#define MODE_B 2
#define MODE_CHANGE SIGRTMIN +1

int mode = MODE_A;

void change_mode(int signum, siginfo_t *data, void *extra) {
  mode = data -> si_value.sival_int;
}

int main() {

  sigset_t mask, omask;
  struct sigaction s, os;
  int local_mode;

  s.sa_flags = 0;
  s.sa_mask = mask;
  s.sa_sigaction = & change_mode;


  sigemptyset(&mask);
  sigaddset(&mask, MODE_CHANGE);

  sigaction(MODE_CHANGE, &s, &os);

  while(1) {

    sigprocmask(SIG_BLOCK, &mask, &omask);
      local_mode = mode;
    sigprocmask(SIG_UNBLOCK, &mask, &omask);

    /* periodic operation using mode*/
    switch(mode) {
      case MODE_A: 
      case MODE_B:
      default: ;
    }
  }
  return 0;
}

