//import javax.realtime.*;
package AA;

public class AtomicActionControl implements ThreeWayAtomicAction 
{
  protected Controller Control;
  public AtomicActionControl()  // constructor
  {
    Control = new Controller();
  }

  class Controller {
    protected boolean firstHere, secondHere, thirdHere;
    protected int allDone;
    protected int toExit;
    protected int numberOfParticipants;

    Controller() 
    {
      firstHere = false;
      secondHere = false;
      thirdHere = false;
      allDone = 0;
      toExit = 3;
      numberOfParticipants = 3;
    }

    synchronized void first() throws InterruptedException
    {
      while(firstHere) wait();
      firstHere = true;
    }

    synchronized void second() throws InterruptedException
    {
      while(secondHere) wait();
      secondHere = true;
    }

    synchronized void third() throws InterruptedException
    {
      while(thirdHere) wait();
      thirdHere = true;
    }

    synchronized void finished() throws InterruptedException
    {
      allDone++;
      if(allDone == numberOfParticipants) {
        notifyAll();
      } else while(allDone != numberOfParticipants) {
           wait();  
      } 
      toExit--;
      if(toExit == 0) {
           System.out.println(" reseeting flags 1");
        firstHere = false;
        secondHere = false;
        thirdHere = false;
        allDone = 0;
        toExit = numberOfParticipants;
      }
    }
  }

  public void role1() 
  {
    System.out.println(" role1 running ");
    boolean done = false;
    while(!done) {
      try {
        Control.first();
        done = true;
      } catch (InterruptedException e) {
        // ignore
      }
    } 

    // .... perform action
    System.out.println(" role1 ACTION ");
    try {
      Thread.sleep(9000);
    } catch (InterruptedException x)  { };
    // .... perform action
    System.out.println(" role1 after sleep ");

    done = false;   
    while(!done) {
      try {
        Control.finished();
        done = true;
      } catch (InterruptedException e) {
        // ignore
      }
    }  
    System.out.println(" role1 finishing ");
  };

  public void role2()
  {
    // similar to role1
    System.out.println(" role2 running ");
    boolean done = false;
    while(!done) {
      try {
        Control.second();
        done = true;
      } catch (InterruptedException e) {
        // ignore
      }
    } 

    // .... perform action
    System.out.println(" role2 ACTION ");
    try {
      Thread.sleep(1000);
    } catch (InterruptedException x)  { };
    System.out.println(" role 2 after sleep ");

    done = false;   
    while(!done) {
      try {
        Control.finished();
        done = true;
      } catch (InterruptedException e) {
        // ignore
      }
    }  
    System.out.println(" role2 finishing ");
  };

  public void role3()
  {
    System.out.println(" role3 running ");
    boolean done = false;
    while(!done) {
      try {
        Control.third();
        done = true;
      } catch (InterruptedException e) {
        // ignore
      }
    } 
    System.out.println(" role3 ACTION ");
    try {
      Thread.sleep(5000);
    } catch (InterruptedException x)  { };
    System.out.println(" role 3 after sleep ");

    // .... perform action

    done = false;   
    while(!done) {
      try {
        Control.finished();
        done = true;
      } catch (InterruptedException e) {
        // ignore
      }
    }  
    System.out.println(" role3 finishing ");
  };
}
