/*
 * euredit.java
 *
 * Created on 05 June 2002, 15:26
 */

package euredit;
import javax.swing.*;
import java.io.*;
import java.util.StringTokenizer;
import java.lang.*;
import java.util.Vector;
import java.awt.*;

/**
 *
 * @author  mweeks
 */
public class euredit extends javax.swing.JFrame {
  // class members
  private String separatorText [] = {"space"};
  private String headerText [] = {"No header", "Header present"};
  private String imputeModeSpecifier [] = {"M", "N", "R", "W", "D"};
  private String imputeModeText [] = {"Mean", "Nearest Neighbour", "Random", "Weighted Mean", "Median"};
  private String editModeText [] = {"Impute Mode", "Outlier Mode"};
  private File specFile;

  //
  private String sep;
  private int maxBins, kNN, numVars, numRecs;
  private double errorMargin;
  private String trainingFileName, outputFileName, specFilename;
  private File trainingFile, outputFile;
  
  int skipHeader, editMode;
  String imputeMode = "W";
  
  private FileInputStream ipStream;
  private Vector vecPanel;
  private String typeCodeString;
  private GridLayout attrPanelLayout;
  
  // member variables related to attrPanel's
  private int numVals[];
  private String typeCodes[], range[], description[];
  
  private Boolean fileLoaded, newFlag, killProcess, runningFlag;
  private ProcessThread pt1;    
  
  /** Creates new form euredit */
  public euredit() {
    fileLoaded = Boolean.FALSE;
    newFlag = Boolean.FALSE;
    killProcess = Boolean.FALSE;
    runningFlag = Boolean.FALSE;
    specFilename = "";
    numVars = 2;
    skipHeader = 1;
    editMode = 0;
    imputeMode = "W";
    sep = "S";
    vecPanel = new Vector();
    initComponents();
    jInternalFrame1.setVisible(false);
    jInternalFrame2.setVisible(false);
    jInternalFrame3.setVisible(false);
    jInternalFrame4.setVisible(false);
  }
  
  
  
  private void refreshTypeCodePanel(){
    // Refresh typecode string
    for (int i = 0; i < numVars; i++){
      AttrPanel ap = (AttrPanel)vecPanel.elementAt(i);
      typeCodes[i] = ap.getFieldSpec();
    }
    typeCodeString = typeCodes[0].substring(0,1);
    for (int i = 1; i < numVars; i++)
      typeCodeString = typeCodeString + sep + typeCodes[i].substring(0,1);
  }
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  private void initComponents() {//GEN-BEGIN:initComponents
    buttonGroup1 = new javax.swing.ButtonGroup();
    menuBar = new javax.swing.JMenuBar();
    fileMenu = new javax.swing.JMenu();
    newSpec = new javax.swing.JMenuItem();
    jSeparator1 = new javax.swing.JSeparator();
    LoadSpec = new javax.swing.JMenuItem();
    jSeparator3 = new javax.swing.JSeparator();
    SaveSpec = new javax.swing.JMenuItem();
    SaveAsSpec = new javax.swing.JMenuItem();
    jSeparator4 = new javax.swing.JSeparator();
    aboutMenuItem = new javax.swing.JMenuItem();
    jSeparator2 = new javax.swing.JSeparator();
    exitMenuItem = new javax.swing.JMenuItem();
    Configuration = new javax.swing.JMenu();
    EditSpec = new javax.swing.JMenuItem();
    EditTypeCodes = new javax.swing.JMenuItem();
    Application = new javax.swing.JMenu();
    Run = new javax.swing.JMenuItem();
    Halt = new javax.swing.JMenuItem();
    desktopPane = new javax.swing.JDesktopPane();
    jInternalFrame1 = new javax.swing.JInternalFrame();
    jLabel1 = new javax.swing.JLabel();
    jLabel24 = new javax.swing.JLabel();
    jLabel23 = new javax.swing.JLabel();
    jLabel3 = new javax.swing.JLabel();
    jLabel22 = new javax.swing.JLabel();
    jButton1 = new javax.swing.JButton();
    jInternalFrame2 = new javax.swing.JInternalFrame();
    jLabel4 = new javax.swing.JLabel();
    jTextField1 = new javax.swing.JTextField();
    jTextField1.setText(specFilename);
    jTextField1.setEditable(false);
    jLabel5 = new javax.swing.JLabel();
    jTextField2 = new javax.swing.JTextField();
    jLabel6 = new javax.swing.JLabel();
    jTextField3 = new javax.swing.JTextField();
    jLabel7 = new javax.swing.JLabel();
    jTextField4 = new javax.swing.JTextField();
    jLabel9 = new javax.swing.JLabel();
    jButton8 = new javax.swing.JButton();
    jLabel10 = new javax.swing.JLabel();
    jTextField6 = new javax.swing.JTextField();
    jLabel12 = new javax.swing.JLabel();
    jTextField8 = new javax.swing.JTextField();
    jLabel13 = new javax.swing.JLabel();
    jTextField9 = new javax.swing.JTextField();
    jLabel8 = new javax.swing.JLabel();
    jComboBox2 = new javax.swing.JComboBox(headerText);
    jLabel15 = new javax.swing.JLabel();
    jComboBox4 = new javax.swing.JComboBox(editModeText);
    jLabel16 = new javax.swing.JLabel();
    jComboBox3 = new javax.swing.JComboBox(imputeModeText);
    jPanel3 = new javax.swing.JPanel();
    jPanel4 = new javax.swing.JPanel();
    jButton2 = new javax.swing.JButton();
    jInternalFrame3 = new javax.swing.JInternalFrame();
    jPanel1 = new javax.swing.JPanel();
    jLabel14 = new javax.swing.JLabel();
    jComboBox1 = new javax.swing.JComboBox(separatorText);
    
    
    
    
    jLabel27 = new javax.swing.JLabel();
    jButton7 = new javax.swing.JButton();
    jButton3 = new javax.swing.JButton();
    jButton6 = new javax.swing.JButton();
    jLabel28 = new javax.swing.JLabel();
    jButton4 = new javax.swing.JButton();
    jPanel5 = new javax.swing.JPanel();
    jLabel26 = new javax.swing.JLabel();
    jLabel18 = new javax.swing.JLabel();
    jLabel19 = new javax.swing.JLabel();
    jLabel20 = new javax.swing.JLabel();
    jLabel21 = new javax.swing.JLabel();
    jScrollPane1 = new javax.swing.JScrollPane();
    jPanel2 = new javax.swing.JPanel();
    attrPanelLayout = new GridLayout(3,1);
    
    updateAttributePanel();
    
    jInternalFrame4 = new javax.swing.JInternalFrame();
    jLabel11 = new javax.swing.JLabel();
    jLabel17 = new javax.swing.JLabel();
    jButton5 = new javax.swing.JButton();
    
    fileMenu.setText("File");
    newSpec.setText("new");
    newSpec.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        newSpecActionPerformed(evt);
      }
    });
    
    fileMenu.add(newSpec);
    fileMenu.add(jSeparator1);
    LoadSpec.setText("Load spec");
    LoadSpec.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        LoadSpecActionPerformed(evt);
      }
    });
    
    fileMenu.add(LoadSpec);
    fileMenu.add(jSeparator3);
    SaveSpec.setText("Save spec");
    SaveSpec.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        SaveSpecActionPerformed(evt);
      }
    });
    
    fileMenu.add(SaveSpec);
    SaveAsSpec.setText("Save Spec As ...");
    SaveAsSpec.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        SaveAsSpecActionPerformed(evt);
      }
    });
    
    fileMenu.add(SaveAsSpec);
    fileMenu.add(jSeparator4);
    aboutMenuItem.setText("About");
    aboutMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        aboutMenuItemActionPerformed(evt);
      }
    });
    
    fileMenu.add(aboutMenuItem);
    fileMenu.add(jSeparator2);
    exitMenuItem.setText("Exit");
    exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        exitMenuItemActionPerformed(evt);
      }
    });
    
    fileMenu.add(exitMenuItem);
    menuBar.add(fileMenu);
    Configuration.setText("Edit");
    Configuration.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        ConfigurationActionPerformed(evt);
      }
    });
    
    EditSpec.setText("Spec");
    EditSpec.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        EditSpecActionPerformed(evt);
      }
    });
    
    Configuration.add(EditSpec);
    EditTypeCodes.setText("Type codes");
    EditTypeCodes.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        EditTypeCodesActionPerformed(evt);
      }
    });
    
    Configuration.add(EditTypeCodes);
    menuBar.add(Configuration);
    Application.setText("Application");
    Application.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        ApplicationActionPerformed(evt);
      }
    });
    
    Run.setText("Run");
    Run.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        RunActionPerformed(evt);
      }
    });
    
    Application.add(Run);
    Halt.setText("Halt");
    Halt.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        HaltActionPerformed(evt);
      }
    });
    
    Application.add(Halt);
    menuBar.add(Application);
    
    setTitle("Euredit spec-file Editor: Copyright 2003 University of York");
    setName("Euredit");
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        exitForm(evt);
      }
    });
    
    desktopPane.setPreferredSize(new java.awt.Dimension(900, 700));
    desktopPane.setMinimumSize(new java.awt.Dimension(900, 700));
    desktopPane.addHierarchyListener(new java.awt.event.HierarchyListener() {
      public void hierarchyChanged(java.awt.event.HierarchyEvent evt) {
        desktopPaneHierarchyChanged(evt);
      }
    });
    
    jInternalFrame1.getContentPane().setLayout(new java.awt.GridLayout(6, 1));
    
    jInternalFrame1.setTitle("about");
    jInternalFrame1.setToolTipText("about dialog box");
    jInternalFrame1.setPreferredSize(new java.awt.Dimension(684, 71));
    jLabel1.setText("AURA Euredit spec-file editor");
    jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    jLabel1.setFont(new java.awt.Font("Default", 0, 18));
    jInternalFrame1.getContentPane().add(jLabel1);
    
    jLabel24.setText("Advanced Computer Architecture Group,");
    jLabel24.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    jLabel24.setFont(new java.awt.Font("Default", 0, 12));
    jInternalFrame1.getContentPane().add(jLabel24);
    
    jLabel23.setText("Computer Science Dept.,");
    jLabel23.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    jLabel23.setFont(new java.awt.Font("Default", 0, 12));
    jInternalFrame1.getContentPane().add(jLabel23);
    
    jLabel3.setText("University of York.");
    jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    jLabel3.setFont(new java.awt.Font("Default", 0, 12));
    jInternalFrame1.getContentPane().add(jLabel3);
    
    jLabel22.setText("Copyright 2003 University of York");
    jLabel22.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    jLabel22.setFont(new java.awt.Font("Dialog", 2, 12));
    jInternalFrame1.getContentPane().add(jLabel22);
    
    jButton1.setText("Done");
    jButton1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButton1ActionPerformed(evt);
      }
    });
    
    jButton1.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(java.awt.event.MouseEvent evt) {
        jButton1MouseClicked(evt);
      }
    });
    
    jInternalFrame1.getContentPane().add(jButton1);
    
    desktopPane.add(jInternalFrame1, javax.swing.JLayeredPane.DEFAULT_LAYER);
    jInternalFrame1.setBounds(260, 80, 310, 160);
    
    jInternalFrame2.getContentPane().setLayout(new java.awt.GridLayout(12, 2));
    
    jInternalFrame2.setTitle("Spec-file configuration form");
    jInternalFrame2.setVisible(true);
    jLabel4.setText("Spec File name");
    jLabel4.setMinimumSize(new java.awt.Dimension(42, 12));
    jInternalFrame2.getContentPane().add(jLabel4);
    
    jTextField1.setEditable(false);
    jTextField1.setMinimumSize(new java.awt.Dimension(42, 12));
    jTextField1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jTextField1ActionPerformed(evt);
      }
    });
    
    jInternalFrame2.getContentPane().add(jTextField1);
    
    jLabel5.setText("Max Bins (0 for default)");
    jLabel5.setMinimumSize(new java.awt.Dimension(42, 12));
    jInternalFrame2.getContentPane().add(jLabel5);
    
    jTextField2.setPreferredSize(new java.awt.Dimension(24, 221));
    jTextField2.setMinimumSize(new java.awt.Dimension(42, 12));
    jTextField2.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jTextField2ActionPerformed(evt);
      }
    });
    
    jInternalFrame2.getContentPane().add(jTextField2);
    
    jLabel6.setText("k nearest neighbours");
    jLabel6.setMinimumSize(new java.awt.Dimension(42, 12));
    jInternalFrame2.getContentPane().add(jLabel6);
    
    jTextField3.setMinimumSize(new java.awt.Dimension(42, 12));
    jTextField3.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jTextField3ActionPerformed(evt);
      }
    });
    
    jInternalFrame2.getContentPane().add(jTextField3);
    
    jLabel7.setText("Error margin");
    jLabel7.setMinimumSize(new java.awt.Dimension(42, 12));
    jInternalFrame2.getContentPane().add(jLabel7);
    
    jTextField4.setMinimumSize(new java.awt.Dimension(42, 12));
    jTextField4.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jTextField4ActionPerformed(evt);
      }
    });
    
    jInternalFrame2.getContentPane().add(jTextField4);
    
    jLabel9.setText("Training data file name");
    jLabel9.setMinimumSize(new java.awt.Dimension(42, 12));
    jInternalFrame2.getContentPane().add(jLabel9);
    
    jButton8.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButton8ActionPerformed(evt);
      }
    });
    
    jInternalFrame2.getContentPane().add(jButton8);
    
    jLabel10.setText("Output data file name");
    jLabel10.setMinimumSize(new java.awt.Dimension(42, 12));
    jInternalFrame2.getContentPane().add(jLabel10);
    
    jTextField6.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
    jTextField6.setMinimumSize(new java.awt.Dimension(42, 12));
    jTextField6.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jTextField6ActionPerformed(evt);
      }
    });
    
    jInternalFrame2.getContentPane().add(jTextField6);
    
    jLabel12.setText("Number of variables");
    jLabel12.setMinimumSize(new java.awt.Dimension(42, 12));
    jInternalFrame2.getContentPane().add(jLabel12);
    
    jTextField8.setMinimumSize(new java.awt.Dimension(42, 12));
    jTextField8.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jTextField8ActionPerformed(evt);
      }
    });
    
    jInternalFrame2.getContentPane().add(jTextField8);
    
    jLabel13.setText("Number of records");
    jLabel13.setMinimumSize(new java.awt.Dimension(42, 12));
    jInternalFrame2.getContentPane().add(jLabel13);
    
    jTextField9.setMinimumSize(new java.awt.Dimension(42, 12));
    jTextField9.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jTextField9ActionPerformed(evt);
      }
    });
    
    jInternalFrame2.getContentPane().add(jTextField9);
    
    jLabel8.setText("Header");
    jLabel8.setToolTipText("treat first line of file as data or header");
    jLabel8.setMinimumSize(new java.awt.Dimension(42, 12));
    jInternalFrame2.getContentPane().add(jLabel8);
    
    jComboBox2.setMinimumSize(new java.awt.Dimension(42, 12));
    jComboBox2.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jComboBox2ActionPerformed(evt);
      }
    });
    
    jInternalFrame2.getContentPane().add(jComboBox2);
    
    jLabel15.setText("Edit mode");
    jLabel15.setToolTipText("Edit or Impute mode");
    jLabel15.setMinimumSize(new java.awt.Dimension(42, 12));
    jInternalFrame2.getContentPane().add(jLabel15);
    
    jComboBox4.setMinimumSize(new java.awt.Dimension(42, 12));
    jComboBox4.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jComboBox4ActionPerformed(evt);
      }
    });
    
    jInternalFrame2.getContentPane().add(jComboBox4);
    
    jLabel16.setText("Impute mode");
    jLabel16.setToolTipText("Imputation method");
    jLabel16.setMinimumSize(new java.awt.Dimension(42, 12));
    jInternalFrame2.getContentPane().add(jLabel16);
    
    jComboBox3.setMinimumSize(new java.awt.Dimension(42, 12));
    jComboBox3.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jComboBox3ActionPerformed(evt);
      }
    });
    
    jInternalFrame2.getContentPane().add(jComboBox3);
    
    jPanel3.setPreferredSize(new java.awt.Dimension(161, 50));
    jInternalFrame2.getContentPane().add(jPanel3);
    
    jPanel4.setLayout(new java.awt.BorderLayout());
    
    jPanel4.setPreferredSize(new java.awt.Dimension(75, 50));
    jButton2.setToolTipText("press when viewing is complete");
    jButton2.setText("Done");
    jButton2.setMinimumSize(new java.awt.Dimension(42, 12));
    jButton2.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButton2ActionPerformed(evt);
      }
    });
    
    jButton2.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(java.awt.event.MouseEvent evt) {
        jButton2MouseClicked(evt);
      }
    });
    
    jPanel4.add(jButton2, java.awt.BorderLayout.CENTER);
    
    jInternalFrame2.getContentPane().add(jPanel4);
    
    desktopPane.add(jInternalFrame2, javax.swing.JLayeredPane.DEFAULT_LAYER);
    jInternalFrame2.setBounds(10, 240, 460, 420);
    
    jInternalFrame3.getContentPane().setLayout(null);
    
    jInternalFrame3.setTitle("Variable configuration form");
    jInternalFrame3.setResizable(true);
    jInternalFrame3.setPreferredSize(new java.awt.Dimension(700, 650));
    jInternalFrame3.setMinimumSize(getPreferredSize());
    jInternalFrame3.setVisible(true);
    jInternalFrame3.addComponentListener(new java.awt.event.ComponentAdapter() {
      public void componentResized(java.awt.event.ComponentEvent evt) {
        jInternalFrame3ComponentResized(evt);
      }
    });
    
    jPanel1.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));
    
    jPanel1.setPreferredSize(new java.awt.Dimension(700, 650));
    jPanel1.setMinimumSize(new java.awt.Dimension(700, 650));
    jPanel1.setAutoscrolls(true);
    jLabel14.setText("Separator");
    jPanel1.add(jLabel14);
    
    jComboBox1.setMinimumSize(new java.awt.Dimension(130, 26));
    jComboBox1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jComboBox1ActionPerformed(evt);
      }
    });
    
    jPanel1.add(jComboBox1);
    
    jLabel27.setPreferredSize(new java.awt.Dimension(48, 17));
    jPanel1.add(jLabel27);
    
    jButton7.setText("Generate data ranges");
    jButton7.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButton7ActionPerformed(evt);
      }
    });
    
    jPanel1.add(jButton7);
    
    jButton3.setText("Insert Row");
    jButton3.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButton3ActionPerformed(evt);
      }
    });
    
    jPanel1.add(jButton3);
    
    jButton6.setText("Delete Row");
    jButton6.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButton6ActionPerformed(evt);
      }
    });
    
    jPanel1.add(jButton6);
    
    jLabel28.setPreferredSize(new java.awt.Dimension(48, 17));
    jPanel1.add(jLabel28);
    
    jButton4.setText("Done");
    jButton4.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButton4ActionPerformed(evt);
      }
    });
    
    jButton4.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(java.awt.event.MouseEvent evt) {
        jButton4MouseClicked(evt);
      }
    });
    
    jPanel1.add(jButton4);
    
    jPanel5.setLayout(new java.awt.GridBagLayout());
    java.awt.GridBagConstraints gridBagConstraints1;
    
    jPanel5.setPreferredSize(new java.awt.Dimension(580, 25));
    jPanel5.setMinimumSize(new java.awt.Dimension(580, 25));
    jLabel26.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    jLabel26.setPreferredSize(new java.awt.Dimension(64, 21));
    jLabel26.setMinimumSize(new java.awt.Dimension(64, 21));
    jLabel26.setMaximumSize(new java.awt.Dimension(64, 21));
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints1.insets = new java.awt.Insets(0, 1, 0, 1);
    jPanel5.add(jLabel26, gridBagConstraints1);
    
    jLabel18.setText("Variable description");
    jLabel18.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    jLabel18.setPreferredSize(new java.awt.Dimension(200, 21));
    jLabel18.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
    jLabel18.setMinimumSize(new java.awt.Dimension(200, 21));
    jLabel18.setMaximumSize(new java.awt.Dimension(200, 21));
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints1.insets = new java.awt.Insets(0, 1, 0, 1);
    jPanel5.add(jLabel18, gridBagConstraints1);
    
    jLabel19.setText("Type code");
    jLabel19.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    jLabel19.setPreferredSize(new java.awt.Dimension(120, 21));
    jLabel19.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
    jLabel19.setMinimumSize(new java.awt.Dimension(120, 21));
    jLabel19.setMaximumSize(new java.awt.Dimension(120, 21));
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints1.insets = new java.awt.Insets(0, 1, 0, 1);
    jPanel5.add(jLabel19, gridBagConstraints1);
    
    jLabel20.setText("#values");
    jLabel20.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    jLabel20.setPreferredSize(new java.awt.Dimension(50, 17));
    jLabel20.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints1.insets = new java.awt.Insets(0, 1, 0, 1);
    jPanel5.add(jLabel20, gridBagConstraints1);
    
    jLabel21.setText("Range");
    jLabel21.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    jLabel21.setPreferredSize(new java.awt.Dimension(210, 17));
    jLabel21.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints1.insets = new java.awt.Insets(0, 1, 0, 1);
    jPanel5.add(jLabel21, gridBagConstraints1);
    
    jPanel1.add(jPanel5);
    
    jScrollPane1.setPreferredSize(new java.awt.Dimension(700, 500));
    jPanel2.setLayout(new java.awt.GridLayout(2, 3));
    
    jPanel2.setPreferredSize(new java.awt.Dimension(680, 500));
    jPanel2.setAutoscrolls(true);
    jScrollPane1.setViewportView(jPanel2);
    
    jPanel1.add(jScrollPane1);
    
    jInternalFrame3.getContentPane().add(jPanel1);
    jPanel1.setBounds(0, 0, 990, 630);
    
    desktopPane.add(jInternalFrame3, javax.swing.JLayeredPane.DEFAULT_LAYER);
    jInternalFrame3.setBounds(140, 10, 840, 660);
    
    jInternalFrame4.getContentPane().setLayout(new java.awt.FlowLayout());
    
    jInternalFrame4.setTitle("about");
    jInternalFrame4.setToolTipText("about dialog box");
    jInternalFrame4.setBackground(java.awt.Color.white);
    jInternalFrame4.setPreferredSize(new java.awt.Dimension(684, 71));
    jLabel11.setText("Euredit: CMM.EXE running");
    jLabel11.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    jLabel11.setFont(new java.awt.Font("Dialog", 1, 18));
    jInternalFrame4.getContentPane().add(jLabel11);
    
    jLabel17.setText("Press \"QUIT\" button to stop execution");
    jLabel17.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    jInternalFrame4.getContentPane().add(jLabel17);
    
    jButton5.setText("Halt");
    jButton5.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButton5ActionPerformed(evt);
      }
    });
    
    jInternalFrame4.getContentPane().add(jButton5);
    
    desktopPane.add(jInternalFrame4, javax.swing.JLayeredPane.DEFAULT_LAYER);
    jInternalFrame4.setBounds(260, 80, 310, 160);
    
    getContentPane().add(desktopPane, java.awt.BorderLayout.CENTER);
    
    setJMenuBar(menuBar);
    pack();
  }//GEN-END:initComponents

  private void jComboBox4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox4ActionPerformed
    // Add your handling code here:
  }//GEN-LAST:event_jComboBox4ActionPerformed

  private void jButton5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton5ActionPerformed
    // Add your handling code here:
    jInternalFrame4.setVisible(false);
    pt1.interrupt();
  }//GEN-LAST:event_jButton5ActionPerformed

  private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
    // Add your handling code here:
  }//GEN-LAST:event_jButton1ActionPerformed

  private void HaltActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_HaltActionPerformed
    // Add your handling code here:
    if (runningFlag.equals(Boolean.TRUE)){
      jInternalFrame4.setVisible(false);
      pt1.interrupt();
      runningFlag = Boolean.FALSE;
    }
  }//GEN-LAST:event_HaltActionPerformed
  
  private void ApplicationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ApplicationActionPerformed
    // Add your handling code here:
  }//GEN-LAST:event_ApplicationActionPerformed
  
    private void jButton8ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton8ActionPerformed
      // Enter Training data filename:
      JFileChooser trainingFileChooser = new JFileChooser();
      ExampleFileFilter filter = new ExampleFileFilter();
      filter.addExtension("csv");
      filter.setDescription("csv files only");
      trainingFileChooser.setFileFilter(filter);
      trainingFileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
      int result = trainingFileChooser.showOpenDialog(this);
      if (result == JFileChooser.CANCEL_OPTION)
        return;
      trainingFile = trainingFileChooser.getSelectedFile();
      if (trainingFile == null || trainingFile.getName().equals(""))
        JOptionPane.showMessageDialog(this, "Invalid Filename", "Invalid File name",
        JOptionPane.ERROR_MESSAGE);
      else {
        trainingFileName = trainingFile.getAbsolutePath();
        jButton8.setText(trainingFileName);
      }
    }//GEN-LAST:event_jButton8ActionPerformed
    
    private void jButton7ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton7ActionPerformed
      String typeCodeStr = new String("");
      String defaultString = new String("");
      for (int i = 0; i < numVars; i++){
        AttrPanel panel = (AttrPanel)vecPanel.elementAt(i);
        typeCodes[i] = panel.getFieldSpec();
        numVals[i] = panel.getNumValues();
        range[i] = panel.getRange();
        description[i] = panel.getDescription();
      }
      
      for (int i = 0; i < numVars; i++){
        AttrPanel ap = (AttrPanel)vecPanel.elementAt(i);
        defaultString = defaultString + "null" + ",";
        typeCodeStr = typeCodeStr + ap.getFieldSpec() + "S";
      }
      File newTrainingFile = new File(trainingFile + "~");
      ProcessData pd = new ProcessData();
      
      pd.initialise(trainingFile, newTrainingFile, numVars, jComboBox2.getSelectedIndex(), typeCodeStr, defaultString);
      pd.generate();
      for (int i = 0; i < numVars; i++){
        if(typeCodes[i].charAt(0) != 'X'){
          range[i] = pd.getRange(i);
          numVals[i] = pd.getNumVals(i);
        }
      }
      updateAttributePanel();
      jInternalFrame3.setVisible(false);
      jInternalFrame3.setVisible(true);
    }//GEN-LAST:event_jButton7ActionPerformed
    
    private void jButton6ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton6ActionPerformed
      // delete a variable
      if (numVars < 1){
        JOptionPane.showMessageDialog(null, "There are no more variables to delete", "Warning", JOptionPane.ERROR_MESSAGE);
        return;
      }
      String rowNumber [] = new String [numVars];
      for (int i = 0; i < numVars; i++)
        rowNumber[i] = String.valueOf(i+1);
      JComboBox rowSelect = new JComboBox(rowNumber);
      rowSelect.setName("Row Number");
      Object[] options = {rowSelect, "delete", "cancel"};
      int n = JOptionPane.showOptionDialog(null,
      "Delete Variable",
      "Choose one!",
      JOptionPane.YES_NO_CANCEL_OPTION,
      JOptionPane.QUESTION_MESSAGE,
      null,
      options,
      options[2]);
      int newRow = rowSelect.getSelectedIndex();
      AttrPanel panel;
      int numValsTemp[];
      String typeCodesTemp[], rangeTemp[], descriptionTemp[];
      numVars--;
      
      // reallocate attrPanel arrays
      typeCodesTemp = new String[numVars];
      numValsTemp = new int[numVars];
      rangeTemp = new String[numVars];
      descriptionTemp = new String [numVars];
      
      switch (n){
        case 0:
          break;
        case 1:
          jTextField8.setText(String.valueOf(numVars));
          for (int i = 0; i < newRow; i++){
            panel = (AttrPanel)vecPanel.elementAt(i);
            typeCodesTemp[i] = panel.getFieldSpec();
            rangeTemp[i] = panel.getRange();
            descriptionTemp[i] = panel.getDescription();
            numValsTemp[i] = panel.getNumValues();
          }
          for (int i = newRow; i < numVars; i++){
            panel = (AttrPanel)vecPanel.elementAt(i + 1);
            typeCodesTemp[i] = panel.getFieldSpec();
            rangeTemp[i] = panel.getRange();
            descriptionTemp[i] = panel.getDescription();
            numValsTemp[i] = panel.getNumValues();
          }
          numVals = numValsTemp;
          typeCodes = typeCodesTemp;
          range = rangeTemp;
          description = descriptionTemp;
          updateAttributePanel();
          jInternalFrame3.setVisible(false);
          jInternalFrame3.setVisible(true);
          break;
        case 2:
          numVars++;
          break;
      }
    }//GEN-LAST:event_jButton6ActionPerformed
    
    
    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
      // Add your handling code here:
    }//GEN-LAST:event_jButton4ActionPerformed
    
    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
      // Add attributes
      String rowNumber [] = new String [numVars];
      for (int i = 0; i < numVars; i++)
        rowNumber[i] = String.valueOf(i+1);
      JComboBox rowSelect = new JComboBox(rowNumber);
      rowSelect.setName("Row Number");
      Object[] options = {rowSelect, "before", "after", "cancel"};
      int n = JOptionPane.showOptionDialog(null,
      "Add Variable",
      "Choose one!",
      JOptionPane.YES_NO_CANCEL_OPTION,
      JOptionPane.QUESTION_MESSAGE,
      null,
      options,
      options[3]);
      int newRow = rowSelect.getSelectedIndex();
      AttrPanel panel;
      int numValsTemp[];
      String typeCodesTemp[], rangeTemp[], descriptionTemp[];
      numVars++;
      jTextField8.setText(String.valueOf(numVars));
      
      // reallocate attrPanel arrays
      typeCodesTemp = new String[numVars];
      numValsTemp = new int[numVars];
      rangeTemp = new String[numVars];
      descriptionTemp = new String [numVars];
      
      switch (n){
        case 0:
          break;
        case 1: case 2:
          n--;
          for (int i = 0; i < newRow + n; i++){
            panel = (AttrPanel)vecPanel.elementAt(i);
            typeCodesTemp[i] = panel.getFieldSpec();
            rangeTemp[i] = panel.getRange();
            descriptionTemp[i] = panel.getDescription();
            numValsTemp[i] = panel.getNumValues();
          }
          typeCodesTemp[newRow + n] = "X";
          rangeTemp[newRow + n] = "NULL";
          descriptionTemp[newRow + n] = "variable" + (newRow + n + 1);
          numValsTemp[newRow + n] = 0;
          for (int i = newRow + n + 1; i < numVars; i++){
            panel = (AttrPanel)vecPanel.elementAt(i-1);
            typeCodesTemp[i] = panel.getFieldSpec();
            rangeTemp[i] = panel.getRange();
            descriptionTemp[i] = panel.getDescription();
            numValsTemp[i] = panel.getNumValues();
          }
          numVals = numValsTemp;
          typeCodes = typeCodesTemp;
          range = rangeTemp;
          description = descriptionTemp;
          updateAttributePanel();
          jInternalFrame3.setVisible(false);
          jInternalFrame3.setVisible(true);
          break;
        case 3:
          numVars--;
          break;
      }
      
    }//GEN-LAST:event_jButton3ActionPerformed
    
    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
      // Add your handling code here:
    }//GEN-LAST:event_jButton2ActionPerformed
    
    private void newSpecActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newSpecActionPerformed
      // new file selected
      maxBins = 0;
      jTextField2.setText(String.valueOf(maxBins));
      kNN = 0;
      jTextField3.setText(String.valueOf(kNN));
      errorMargin = 1.00;
      jTextField4.setText(String.valueOf(errorMargin));
      trainingFileName = "";
      jButton8.setText(trainingFileName);
      outputFileName = "";
      jTextField6.setText(outputFileName);
      specFile = null;
      specFilename = "";
      jTextField1.setText(specFilename);
      numVars = 0;
      jTextField8.setText(String.valueOf(numVars));
      numRecs = 0;
      jTextField9.setText(String.valueOf(numRecs));
      newFlag = Boolean.TRUE;
      fileLoaded = Boolean.FALSE;
      jInternalFrame2.setVisible(true);
      sep = "S";
      skipHeader = 1;
      jComboBox2.setSelectedIndex(1);
      editMode = 0;
      jComboBox4.setSelectedIndex(0);
      imputeMode = "W";
      jComboBox3.setSelectedIndex(3);
    }//GEN-LAST:event_newSpecActionPerformed
    
    private void jComboBox3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox3ActionPerformed
      // Add your handling code here:
    }//GEN-LAST:event_jComboBox3ActionPerformed
    
    private void jTextField9ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField9ActionPerformed
      // Add your handling code here:
      numRecs = Integer.parseInt(jTextField2.getText());
    }//GEN-LAST:event_jTextField9ActionPerformed
    
    private void jTextField8ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField8ActionPerformed
      // Add your handling code here:
      numVars = Integer.parseInt(jTextField8.getText());
    }//GEN-LAST:event_jTextField8ActionPerformed
        
    private void jTextField6ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField6ActionPerformed
      // Add your handling code here:
      outputFileName = jTextField6.getText();
      outputFile = new File(outputFileName);
    }//GEN-LAST:event_jTextField6ActionPerformed
    
    private void jTextField4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField4ActionPerformed
      // Add your handling code here:
      errorMargin = Float.parseFloat(jTextField4.getText());
    }//GEN-LAST:event_jTextField4ActionPerformed
    
    private void SaveAsSpecActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SaveAsSpecActionPerformed
      // Save spec file under different name
      JFileChooser specFileChooser = new JFileChooser();
      ExampleFileFilter filter = new ExampleFileFilter();
      filter.addExtension("spc");
      filter.setDescription("Euredit spec files only");
      specFileChooser.setFileFilter(filter);
      specFileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
      int result = specFileChooser.showSaveDialog(this);
      if (result == JFileChooser.CANCEL_OPTION)
        return;
      specFile = specFileChooser.getSelectedFile();
      specFilename = specFile.getAbsolutePath();
      jTextField1.setText(specFilename);
      
      if (specFile == null || specFile.getName().equals(""))
        JOptionPane.showMessageDialog(this, "Invalid File Name", "Name", JOptionPane.ERROR_MESSAGE);
      else{
        try{
          // save spec file.
          // I tried to use ObjectOutputStream but it put garbage at beginning of file
          FileOutputStream output = new FileOutputStream(specFile);
          output.write(String.valueOf(maxBins).getBytes());
          output.write("\t// max number of bins (0 - auto select)\r\n".getBytes());
          output.write(String.valueOf(kNN).getBytes());
          output.write("\t// k Nearest Neighbours \r\n".getBytes());
          output.write(String.valueOf(errorMargin).getBytes());
          output.write("\t// Error margin \r\n".getBytes());
          output.write(trainingFileName.getBytes());
          output.write("\t// training filename \r\n".getBytes());
          output.write(outputFileName.getBytes());
          output.write("\t// output filename \r\n".getBytes());
          output.write(String.valueOf(numVars).getBytes());
          output.write("\t// Number of variables/fields \r\n".getBytes());
          output.write(String.valueOf(numRecs).getBytes());
          output.write("\t// Number of records \r\n".getBytes());
          output.write(typeCodeString.getBytes());
          output.write("\t// typecode string \r\n".getBytes());
          output.write(String.valueOf(jComboBox2.getSelectedIndex()).getBytes());
          output.write("\t// Header?? \r\n".getBytes());
          output.write(String.valueOf(jComboBox4.getSelectedIndex()).getBytes());
          output.write("\t// Edit mode specifier \r\n".getBytes());
          output.write(imputeModeSpecifier[jComboBox3.getSelectedIndex()].getBytes());
          output.write("\t// Impute mode specifier \r\n".getBytes());
          // save variables
          for (int i = 0; i < numVars; i++){
            AttrPanel ap = (AttrPanel)vecPanel.elementAt(i);
            output.write(ap.getFieldSpec().getBytes());
            output.write(" ".getBytes());
            output.write(String.valueOf(ap.getNumValues()).getBytes());
            output.write(" ".getBytes());
            output.write(ap.getRange().getBytes());
            output.write(" // ".getBytes());
            output.write(ap.getDescription().getBytes());
            output.write("\r\n".getBytes());
          }
          output.close();
        }
        catch (FileNotFoundException e){
          JOptionPane.showMessageDialog(this, "File not found", "Error", JOptionPane.ERROR_MESSAGE);
          return;
        }
        catch (IOException e){
          JOptionPane.showMessageDialog(this, "Error Saving File", "Error", JOptionPane.ERROR_MESSAGE);
          return;
        }
      }
      
    }//GEN-LAST:event_SaveAsSpecActionPerformed
    
    private void SaveSpecActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SaveSpecActionPerformed
      // Add your handling code here:
      // Save spec file under different name
      if (specFile == null){
        JFileChooser specFileChooser = new JFileChooser();
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension("spc");
        filter.setDescription("Euredit spc files only");
        specFileChooser.setFileFilter(filter);
        specFileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        int result = specFileChooser.showSaveDialog(this);
        if (result == JFileChooser.CANCEL_OPTION)
          return;
        specFile = specFileChooser.getSelectedFile();
        specFilename = specFile.getAbsolutePath();
        jTextField1.setText(specFilename);
        
        if (specFile == null || specFile.getName().equals(""))
          JOptionPane.showMessageDialog(this, "Invalid File Name", "Name", JOptionPane.ERROR_MESSAGE);
        else{
          try{
            // save spec file.
            // I tried to use ObjectOutputStream but it put garbage at beginning of file
            FileOutputStream output = new FileOutputStream(specFile);
            output.write(String.valueOf(maxBins).getBytes());
            output.write("\t// max number of bins (0 - auto select) \r\n".getBytes());
            output.write(String.valueOf(kNN).getBytes());
            output.write("\t// k Nearest Neighbours \r\n".getBytes());
            output.write(String.valueOf(errorMargin).getBytes());
            output.write("\t// Error margin \r\n".getBytes());
            output.write(trainingFileName.getBytes());
            output.write("\t// training filename \r\n".getBytes());
            output.write(outputFileName.getBytes());
            output.write("\t// output filename \r\n".getBytes());
            output.write(String.valueOf(numVars).getBytes());
            output.write("\t// Number of variables/fields \r\n".getBytes());
            output.write(String.valueOf(numRecs).getBytes());
            output.write("\t// Number of records \r\n".getBytes());
            output.write(typeCodeString.getBytes());
            output.write("\t// typecode string \r\n".getBytes());
            output.write(String.valueOf(jComboBox2.getSelectedIndex()).getBytes());
            output.write("\t// Header?? \r\n".getBytes());
            output.write(String.valueOf(jComboBox4.getSelectedIndex()).getBytes());
            output.write("\t// Edit mode specifier \r\n".getBytes());
            output.write(imputeModeSpecifier[jComboBox3.getSelectedIndex()].getBytes());
            output.write("\t// Impute mode specifier \r\n".getBytes());
            // save variables
            for (int i = 0; i < numVars; i++){
              AttrPanel ap = (AttrPanel)vecPanel.elementAt(i);
              output.write(ap.getFieldSpec().getBytes());
              output.write(" ".getBytes());
              output.write(String.valueOf(ap.getNumValues()).getBytes());
              output.write(" ".getBytes());
              output.write(ap.getRange().getBytes());
              output.write(" // ".getBytes());
              output.write(ap.getDescription().getBytes());
              output.write(" \r\n".getBytes());
            }
            output.close();
          }
          catch (FileNotFoundException e){
            JOptionPane.showMessageDialog(this, "File not found", "Error", JOptionPane.ERROR_MESSAGE);
            return;
          }
          catch (IOException e){
            JOptionPane.showMessageDialog(this, "Error Saving File", "Error", JOptionPane.ERROR_MESSAGE);
            return;
          }
        }
      } else {
        // save spec file.
        // I tried to use ObjectOutputStream but it put garbage at beginning of file
        try{
          FileOutputStream output = new FileOutputStream(specFile);
          output.write(String.valueOf(maxBins).getBytes());
          output.write("\t// max number of bins (0 - auto select)\r\n".getBytes());
          output.write(String.valueOf(kNN).getBytes());
          output.write("\t// k Nearest Neighbours \r\n".getBytes());
          output.write(String.valueOf(errorMargin).getBytes());
          output.write("\t// Error margin \r\n".getBytes());
          output.write(trainingFileName.getBytes());
          output.write("\t// training filename \r\n".getBytes());
          output.write(outputFileName.getBytes());
          output.write("\t// output filename \r\n".getBytes());
          output.write(String.valueOf(numVars).getBytes());
          output.write("\t// Number of variables/fields \r\n".getBytes());
          output.write(String.valueOf(numRecs).getBytes());
          output.write("\t// Number of records \r\n".getBytes());
          output.write(typeCodeString.getBytes());
          output.write("\t// typecode string \r\n".getBytes());
          output.write(String.valueOf(jComboBox2.getSelectedIndex()).getBytes());
          output.write("\t// Header?? \r\n".getBytes());
          output.write(String.valueOf(jComboBox4.getSelectedIndex()).getBytes());
          output.write("\t// Edit mode specifier \r\n".getBytes());
          output.write(imputeModeSpecifier[jComboBox3.getSelectedIndex()].getBytes());
          output.write("\t// Impute mode specifier \r\n".getBytes());
          // save variables
          for (int i = 0; i < numVars; i++){
            AttrPanel ap = (AttrPanel)vecPanel.elementAt(i);
            output.write(ap.getFieldSpec().getBytes());
            output.write(" ".getBytes());
            output.write(String.valueOf(ap.getNumValues()).getBytes());
            output.write(" ".getBytes());
            output.write(ap.getRange().getBytes());
            output.write(" // ".getBytes());
            output.write(ap.getDescription().getBytes());
            output.write("\r\n".getBytes());
          }
          output.close();
        }
        catch (FileNotFoundException e){
          JOptionPane.showMessageDialog(this, "File not found", "Error", JOptionPane.ERROR_MESSAGE);
          return;
        }
        catch (IOException e){
          JOptionPane.showMessageDialog(this, "Error Saving File", "Error", JOptionPane.ERROR_MESSAGE);
          return;
        }
      }
    }//GEN-LAST:event_SaveSpecActionPerformed
    
    private void jComboBox2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox2ActionPerformed
      // Add your handling code here:
      
    }//GEN-LAST:event_jComboBox2ActionPerformed
    
    private void EditTypeCodesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_EditTypeCodesActionPerformed
      // bring up attribute "edit screen"
      jInternalFrame3.setVisible(true);
      jInternalFrame2.setVisible(false);
      
      int temp = jComboBox1.getSelectedIndex();
      switch (temp){
        case 0: sep = "S"; break;
        case 1: sep = ","; break;
        case 2: sep = "."; break;
      }
      refreshTypeCodePanel();
    }//GEN-LAST:event_EditTypeCodesActionPerformed
        
    private void jInternalFrame3ComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_jInternalFrame3ComponentResized
      // Resizes windows
      // THIS DOESN'T SEEM TO WORK!!!!
      Dimension temp = new Dimension(jInternalFrame3.getWidth(), jInternalFrame3.getHeight());
      jPanel1.setPreferredSize(temp);
    }//GEN-LAST:event_jInternalFrame3ComponentResized
            
    private void jTextField1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField1ActionPerformed
      // Add your handling code here:
    }//GEN-LAST:event_jTextField1ActionPerformed
    
    private void specFileChooserActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_specFileChooserActionPerformed
                        }//GEN-LAST:event_specFileChooserActionPerformed
                        
    private void jComboBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
      // combobox selector for typecodestring spacer
      int temp = jComboBox1.getSelectedIndex(); // fixed for option 0
      switch (temp){
        case 0: sep = "S"; break; // Space selected
        case 1: sep = ","; break; // Comma selected
        case 2: sep = "."; break; // Dot selected
      }
      refreshTypeCodePanel();
    }//GEN-LAST:event_jComboBox1ActionPerformed
    
    private void jButton4MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton4MouseClicked
      // Add your handling code here:
      //jInternalFrame2.setVisible(true);
      refreshTypeCodePanel();
      jInternalFrame3.setVisible(false);
    }//GEN-LAST:event_jButton4MouseClicked
    
    private void EditSpecActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_EditSpecActionPerformed
      // Add your handling code here:
      jInternalFrame2.setVisible(true);
    }//GEN-LAST:event_EditSpecActionPerformed
    
    private void jButton2MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton2MouseClicked
      // close "spec file config form"
      jInternalFrame2.setVisible(false);
      numVars = Integer.parseInt(jTextField8.getText());
      if (newFlag == Boolean.TRUE){
        // reallocate attrPanel arrays
        typeCodes = new String[numVars];
        numVals = new int[numVars];
        range = new String[numVars];
        description = new String [numVars];
      }
      
      maxBins = Integer.parseInt(jTextField2.getText());
      kNN = Integer.parseInt(jTextField3.getText());
      errorMargin = Double.parseDouble(jTextField4.getText());
      trainingFileName = jButton8.getText();
      trainingFile = new File(trainingFileName);
      outputFileName = jTextField6.getText();
      outputFile = new File(outputFileName);
      numRecs = Integer.parseInt(jTextField9.getText());
      updateAttributePanel();
    }//GEN-LAST:event_jButton2MouseClicked
    
    private void jTextField3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField3ActionPerformed
      // Add your handling code here:
      kNN = Integer.parseInt(jTextField3.getText());
    }//GEN-LAST:event_jTextField3ActionPerformed
    
    private void jTextField2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField2ActionPerformed
      // Add your handling code here:
      maxBins = Integer.parseInt(jTextField2.getText());
    }//GEN-LAST:event_jTextField2ActionPerformed
    
    private void RunActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_RunActionPerformed
      // Add your handling code here:
      if (fileLoaded.equals(Boolean.TRUE)){
        runningFlag = Boolean.TRUE;
        jInternalFrame4.setVisible(true);
        pt1 = new ProcessThread(jInternalFrame4, specFilename);
        pt1.start();
      }
      else {
        JOptionPane.showMessageDialog(this, "There is no spc file present", "Spec File error", JOptionPane.ERROR_MESSAGE);
      }
    }//GEN-LAST:event_RunActionPerformed
    
    private void desktopPaneHierarchyChanged(java.awt.event.HierarchyEvent evt) {//GEN-FIRST:event_desktopPaneHierarchyChanged
      // Add your handling code here:
    }//GEN-LAST:event_desktopPaneHierarchyChanged
        
    private void ConfigurationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ConfigurationActionPerformed
      
    }//GEN-LAST:event_ConfigurationActionPerformed
    
    private void LoadSpecActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_LoadSpecActionPerformed
      JFileChooser specFileChooser = new JFileChooser();
      ExampleFileFilter filter = new ExampleFileFilter();
      filter.addExtension("spc");
      filter.setDescription("Euredit spc files only");
      specFileChooser.setFileFilter(filter);
      specFileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
      int result = specFileChooser.showOpenDialog(this);
      if (result == JFileChooser.CANCEL_OPTION){
        return;
      }
      
      specFile = specFileChooser.getSelectedFile();
      specFilename = specFile.getAbsolutePath();
      jTextField1.setText(specFilename);
      if (specFilename == null || specFile.getName().equals(""))
        JOptionPane.showMessageDialog(this, "Invalid File Name", "Name", JOptionPane.ERROR_MESSAGE);
      else{
        try{
          String str;
          String temp;
          StringTokenizer sT;
          FileReader fr = new FileReader(specFile);
          BufferedReader in = new BufferedReader(fr);//file pointer file
          
          // Read in max_bins
          str = in.readLine();
          sT = new StringTokenizer(str);
          temp = sT.nextToken();
          maxBins = Integer.parseInt(temp);
          jTextField2.setText(temp);
          
          // read in num_neighbours
          str = in.readLine();
          sT = new StringTokenizer(str);
          temp = sT.nextToken();
          kNN = Integer.parseInt(temp);
          jTextField3.setText(temp);
          
          // read in error_margin
          str = in.readLine();
          sT = new StringTokenizer(str);
          temp = sT.nextToken();
          errorMargin = Float.parseFloat(temp);
          jTextField4.setText(temp);
          
          // read in trainingFileName
          str = in.readLine();
          sT = new StringTokenizer(str);
          trainingFileName = sT.nextToken();
          jButton8.setText(trainingFileName);
          trainingFile = new File(trainingFileName);
          
          // read in outputFileName
          str = in.readLine();
          sT = new StringTokenizer(str);
          outputFileName = sT.nextToken();
          jTextField6.setText(outputFileName);
          outputFile = new File(outputFileName);
          
          // read in number of variables
          str = in.readLine();
          sT = new StringTokenizer(str);
          temp = sT.nextToken();
          numVars = Integer.parseInt(temp);
          jTextField8.setText(temp);
          
          // read in number of records
          str = in.readLine();
          sT = new StringTokenizer(str);
          temp = sT.nextToken();
          numRecs = Integer.parseInt(temp);
          jTextField9.setText(temp);
          
          // read in typecode string
          str = in.readLine();
          sT = new StringTokenizer(str);
          typeCodeString = sT.nextToken();
          
          // read in skip_line1
          str = in.readLine();
          sT = new StringTokenizer(str);
          temp = sT.nextToken();
          skipHeader = Integer.parseInt(temp);
          jComboBox2.setSelectedIndex(skipHeader);
          
          // read in EditMode
          str = in.readLine();
          sT = new StringTokenizer(str);
          temp = sT.nextToken();
          editMode = Integer.parseInt(temp);
          jComboBox4.setSelectedIndex(editMode);
          
          // read in ImputeMode
          str = in.readLine();
          sT = new StringTokenizer(str);
          temp = sT.nextToken();
          imputeMode = temp;
          for (int i = 0; i < 5; i++)
            if (imputeMode.equalsIgnoreCase(imputeModeSpecifier[i]))
              jComboBox3.setSelectedIndex(i);
          
          // reallocate attrPanel arrays
          typeCodes = new String[numVars];
          numVals = new int[numVars];
          range = new String[numVars];
          description = new String [numVars];
          
          // Now load in all the variable information
          for (int i = 0; i < numVars; i++){
            // read in line and place in string tokeniser
            str = in.readLine();
            sT = new StringTokenizer(str);
            
            // read in type specifier
            temp = sT.nextToken();
            typeCodes[i] = temp;
            
            if (!typeCodes[i].equals("R") && !typeCodes[i].equals("Z")){
              //read in number of values
              temp = sT.nextToken();
              numVals[i] = Integer.parseInt(temp);
              
              // read in range
              range[i] = "";
              temp = sT.nextToken();
              while(temp.indexOf("//") == -1){
                range[i] = range[i] + " " + temp;
                temp = sT.nextToken();
              }
            }
            else {
              // read in text description
              temp = sT.nextToken();
              while(temp.indexOf("//") == -1){
                temp = sT.nextToken();
              }
            }
            while (sT.hasMoreTokens()){
              if (temp.length() == 0)
                temp = sT.nextToken();
              else
                temp = temp + " " + sT.nextToken();
              description[i] = temp.substring(2, temp.length());
            }
          }
          in.close();
        }
        catch (FileNotFoundException e){
          JOptionPane.showMessageDialog(this, "File not found", "Error", JOptionPane.ERROR_MESSAGE);
          return;
        }
        catch (IOException e){
          JOptionPane.showMessageDialog(this, "Error Opening File", "Error", JOptionPane.ERROR_MESSAGE);
          return;
        }
      }
      
      // clear old AttributePanels
      while (vecPanel.size() > 0){
        AttrPanel aPanel = (AttrPanel)vecPanel.lastElement();
        jPanel2.remove(aPanel);
        vecPanel.removeElementAt(vecPanel.size()-1);
      }
      fileLoaded = Boolean.TRUE;
      updateAttributePanel();
    }//GEN-LAST:event_LoadSpecActionPerformed
        
    private void jButton1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton1MouseClicked
      // Add your handling code here:
      jInternalFrame1.setVisible(false);
    }//GEN-LAST:event_jButton1MouseClicked
    
    private void aboutMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_aboutMenuItemActionPerformed
      // Add your handling code here:
      jInternalFrame1.setVisible(true);
    }//GEN-LAST:event_aboutMenuItemActionPerformed
    
    private void exitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuItemActionPerformed
      System.exit(0);
    }//GEN-LAST:event_exitMenuItemActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
      System.exit(0);
    }//GEN-LAST:event_exitForm
     
    private void updateAttributePanel(){
      if (fileLoaded.equals(Boolean.TRUE)){
      attrPanelLayout.setRows(numVars);
      Dimension attrPanelDim = new Dimension(660, 27*numVars);
      jPanel2.setPreferredSize(attrPanelDim);
      jPanel2.setLayout(attrPanelLayout);
      //jPanel2.validate();
      
      // clear old AttributePanels
      while (vecPanel.size() > 0){
        AttrPanel aPanel = (AttrPanel)vecPanel.lastElement();
        jPanel2.remove(aPanel);
        vecPanel.removeElementAt(vecPanel.size()-1);
      }
      newFlag = Boolean.FALSE;
      for (int i = 0; i < numVars; i++){
        AttrPanel panel;
        if (fileLoaded.equals(Boolean.FALSE))
          panel = new AttrPanel(i+1);
        else
          panel = new AttrPanel(i+1, typeCodes[i], numVals[i], range[i], description[i]);
        jPanel2.add(panel);
        vecPanel.addElement(panel);
      }
      //fileLoaded = Boolean.TRUE;
      }
    }
    
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
      
      new euredit().show();
      
      // Create class instance
      //JniFile mappedFile = new JniFile();
      
      // call native method to to load ReadFile.java
      //byte buf[];
      // call native method to load file
      //buf = mappedFile.loadFile("csl.spc");
      // Print contents of buffer
      //for (int i = 0; i < buf.length; i++)
      //  System.out.print((char)buf[i]);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JMenu fileMenu;
    private javax.swing.JMenuItem newSpec;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JMenuItem LoadSpec;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JMenuItem SaveSpec;
    private javax.swing.JMenuItem SaveAsSpec;
    private javax.swing.JSeparator jSeparator4;
    private javax.swing.JMenuItem aboutMenuItem;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JMenuItem exitMenuItem;
    private javax.swing.JMenu Configuration;
    private javax.swing.JMenuItem EditSpec;
    private javax.swing.JMenuItem EditTypeCodes;
    private javax.swing.JMenu Application;
    private javax.swing.JMenuItem Run;
    private javax.swing.JMenuItem Halt;
    private javax.swing.JDesktopPane desktopPane;
    private javax.swing.JInternalFrame jInternalFrame1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JButton jButton1;
    private javax.swing.JInternalFrame jInternalFrame2;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JTextField jTextField3;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JTextField jTextField4;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JButton jButton8;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JTextField jTextField6;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JTextField jTextField8;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JTextField jTextField9;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JComboBox jComboBox2;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JComboBox jComboBox4;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JComboBox jComboBox3;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JButton jButton2;
    private javax.swing.JInternalFrame jInternalFrame3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JButton jButton7;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton6;
    private javax.swing.JLabel jLabel28;
    private javax.swing.JButton jButton4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JInternalFrame jInternalFrame4;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JButton jButton5;
    // End of variables declaration//GEN-END:variables
}
