/*
 * Decompiled with CFR 0.152.
 */
package util;

public class ReferenceOffsets {
    private short[] offsets = null;
    private short top;
    private short nextScanIndex;

    public byte size() {
        return (byte)this.top;
    }

    public void insert(short i) throws Exception {
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        if (this.top > 255) {
            throw new Exception("Too many references in object");
        }
        if (this.offsets == null) {
            this.offsets = new short[10];
        }
        if (this.top < this.offsets.length) {
            short s = this.top;
            this.top = (short)(s + 1);
            this.offsets[s] = i;
        } else {
            this.extend();
            this.insert(i);
        }
    }

    private void extend() {
        short[] nbyteOffsets = new short[this.offsets.length * 2];
        short i = 0;
        while (i < this.top) {
            nbyteOffsets[i] = this.offsets[i];
            i = (byte)(i + 1);
        }
        this.offsets = nbyteOffsets;
    }

    public byte byteOffsetsSize() {
        short index = 0;
        byte sum = 0;
        while (index < this.top) {
            if (this.offsets[index] < 256) {
                sum = (byte)(sum + 1);
            }
            index = (short)(index + 1);
        }
        return sum;
    }

    public byte shortOffsetsSize() {
        return (byte)(this.top - this.byteOffsetsSize());
    }

    public void startScanByteOffsets() {
        this.nextScanIndex = 0;
    }

    public short getNextByteOffset() {
        while (this.offsets[this.nextScanIndex] > 255) {
            this.nextScanIndex = (short)(this.nextScanIndex + 1);
        }
        short s = this.nextScanIndex;
        this.nextScanIndex = (short)(s + 1);
        short res = this.offsets[s];
        return res;
    }

    public void startScanShortOffsets() {
        this.startScanByteOffsets();
    }

    public short getNextShortOffset() {
        while (this.offsets[this.nextScanIndex] <= 255) {
            this.nextScanIndex = (short)(this.nextScanIndex + 1);
        }
        short s = this.nextScanIndex;
        this.nextScanIndex = (short)(s + 1);
        short res = this.offsets[s];
        return res;
    }
}

