/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.IL2ErrorHandler;

public class L2Channel {
    private static final int L2_PACKET_SIZE = 128;
    private static final int L2_BUFFER_SIZE = 260;
    private static final int DLE = 16;
    private static final int STX = 2;
    private static final int ETX = 3;
    private L2ControlType L2Control;
    private l2_state_t l2_state;
    private byte[] l2_recv_buffer;
    private byte[] l2_send_buffer;
    private int l2_recv_buffer_ptr;
    private short ptr;
    private byte checksum;
    private IL2ErrorHandler errorHandler;
    private static /* synthetic */ int[] $SWITCH_TABLE$util$L2Channel$l2_state_t;

    private static String getL2ErrorString(L2Error error) {
        String result = null;
        switch (error) {
            case DLE_ERROR: {
                result = "DLE_ERROR";
                break;
            }
            case L2_RX_OVERFLOW: {
                result = "L2_RX_OVERFLOW";
                break;
            }
            case L2_TX_OVERFLOW: {
                result = "L2_TX_OVERFLOW";
                break;
            }
            case CHSUM_ERROR: {
                result = "CHSUM_ERROR";
                break;
            }
            case LENGTH_FIELD_ERROR: {
                result = "LENGTH_FIELD_ERROR";
                break;
            }
            case MISSING_START: {
                result = "MISSING_START";
                break;
            }
            case LAST_L2_ERROR: {
                result = "LAST_L2_ERROR";
                break;
            }
            default: {
                result = "UNKNONW";
            }
        }
        return result;
    }

    public L2Channel(IL2ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.L2Control = new L2ControlType();
        this.l2_state = l2_state_t.L2_SYNC_STATE;
        this.l2_recv_buffer_ptr = 0;
        this.l2_recv_buffer = new byte[260];
        this.l2_send_buffer = new byte[260];
    }

    public void receive_callback(byte[] msg) {
    }

    public void send_callback(byte[] msg, short ptr) {
    }

    private void L2ErrorHandler(L2Error error, byte offendingByte) {
        if (this.errorHandler != null) {
            this.errorHandler.errorOccurred(L2Channel.getL2ErrorString(error), offendingByte);
        }
    }

    private static short l2_stuff(byte[] buffer, short ptr, byte c) {
        if (c == 16) {
            short s = ptr;
            ptr = (short)(s + 1);
            buffer[s] = 16;
        }
        short s = ptr;
        ptr = (short)(s + 1);
        buffer[s] = c;
        return ptr;
    }

    public final synchronized void l2_send(byte[] buffer) {
        if (this.prologue((short)buffer.length)) {
            int bufferIndex = 0;
            while (bufferIndex < buffer.length) {
                this.write(buffer[bufferIndex]);
                ++bufferIndex;
            }
            this.epilogue();
        }
    }

    protected void epilogue() {
        short s = this.ptr = L2Channel.l2_stuff(this.l2_send_buffer, this.ptr, this.checksum);
        this.ptr = (short)(s + 1);
        this.l2_send_buffer[s] = 16;
        short s2 = this.ptr;
        this.ptr = (short)(s2 + 1);
        this.l2_send_buffer[s2] = 3;
        this.L2Control.TXBuffer_cnt += (long)this.ptr;
        this.send_callback(this.l2_send_buffer, this.ptr);
    }

    protected void write(byte b) {
        this.ptr = L2Channel.l2_stuff(this.l2_send_buffer, this.ptr, b);
        this.checksum = (byte)(this.checksum + b);
    }

    public boolean prologue(short length) {
        this.ptr = 0;
        this.checksum = 0;
        ++this.L2Control.TXSignal_cnt;
        this.L2Control.TXData_cnt += (long)length;
        if (length >= 128) {
            this.L2ErrorHandler(L2Error.L2_TX_OVERFLOW, (byte)0);
            return false;
        }
        short s = this.ptr;
        this.ptr = (short)(s + 1);
        this.l2_send_buffer[s] = 16;
        short s2 = this.ptr;
        this.ptr = (short)(s2 + 1);
        this.l2_send_buffer[s2] = 2;
        this.ptr = L2Channel.l2_stuff(this.l2_send_buffer, this.ptr, (byte)(length & 0xFF));
        this.ptr = L2Channel.l2_stuff(this.l2_send_buffer, this.ptr, (byte)(length >> 8 & 0xFF));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public final synchronized void l2_recv(byte[] buffer) {
        length = buffer.length;
        this.L2Control.RXBuffer_cnt += (long)length;
        index = 0;
        block6: while (length-- > 0) {
            switch (L2Channel.$SWITCH_TABLE$util$L2Channel$l2_state_t()[this.l2_state.ordinal()]) {
                case 1: {
                    if (buffer[index] == 16) {
                        this.l2_state = l2_state_t.L2_WAIT_STX_STATE;
                    } else {
                        this.L2ErrorHandler(L2Error.MISSING_START, buffer[index]);
                    }
                    ** GOTO lbl61
                }
                case 2: {
                    if (buffer[index] == 2) {
                        this.l2_state = l2_state_t.L2_RECV_STATE;
                        this.l2_recv_buffer_ptr = 0;
                    } else if (buffer[index] != 16) {
                        this.l2_state = l2_state_t.L2_SYNC_STATE;
                        this.L2ErrorHandler(L2Error.MISSING_START, buffer[index]);
                    }
                    ** GOTO lbl61
                }
                case 3: {
                    if (buffer[index] == 16) {
                        this.l2_state = l2_state_t.L2_DLE_STATE;
                    } else {
                        this.l2_recv_buffer[this.l2_recv_buffer_ptr++] = buffer[index];
                    }
                    ** GOTO lbl61
                }
                case 4: {
                    if (buffer[index] != 16) ** GOTO lbl32
                    this.l2_recv_buffer[this.l2_recv_buffer_ptr++] = 16;
                    this.l2_state = l2_state_t.L2_RECV_STATE;
                    ** GOTO lbl61
lbl32:
                    // 1 sources

                    if (buffer[index] == 3) {
                        message_length = this.l2_recv_buffer[0] | this.l2_recv_buffer[1] << 8;
                        if (message_length != this.l2_recv_buffer_ptr - 3) {
                            this.L2ErrorHandler(L2Error.LENGTH_FIELD_ERROR, (byte)0);
                            this.l2_state = l2_state_t.L2_SYNC_STATE;
                            break;
                        }
                        i = 0;
                        checksum = 0;
                        while (i < message_length) {
                            checksum = (byte)(checksum + this.l2_recv_buffer[2 + i]);
                            ++i;
                        }
                        if (checksum != this.l2_recv_buffer[2 + message_length]) {
                            this.l2_state = l2_state_t.L2_SYNC_STATE;
                            this.L2ErrorHandler(L2Error.CHSUM_ERROR, (byte)0);
                            break;
                        }
                        ++this.L2Control.RXSignal_cnt;
                        this.L2Control.RXData_cnt += (long)message_length;
                        message = new byte[message_length];
                        count = 0;
                        while (count < message_length) {
                            message[count] = this.l2_recv_buffer[count + 2];
                            ++count;
                        }
                        this.receive_callback(message);
                        this.l2_state = l2_state_t.L2_SYNC_STATE;
                    } else {
                        this.l2_state = l2_state_t.L2_SYNC_STATE;
                        this.L2ErrorHandler(L2Error.DLE_ERROR, (byte)0);
                    }
                }
lbl61:
                // 10 sources

                default: {
                    ++index;
                    if (this.l2_recv_buffer_ptr < 260) continue block6;
                    this.l2_state = l2_state_t.L2_SYNC_STATE;
                    this.L2ErrorHandler(L2Error.L2_RX_OVERFLOW, (byte)0);
                }
            }
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$util$L2Channel$l2_state_t() {
        if ($SWITCH_TABLE$util$L2Channel$l2_state_t != null) {
            return $SWITCH_TABLE$util$L2Channel$l2_state_t;
        }
        int[] nArray = new int[l2_state_t.values().length];
        try {
            nArray[l2_state_t.L2_DLE_STATE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[l2_state_t.L2_RECV_STATE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[l2_state_t.L2_SYNC_STATE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[l2_state_t.L2_WAIT_STX_STATE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$util$L2Channel$l2_state_t = nArray;
        return nArray;
    }

    private class L2ControlType {
        public long RXSignal_cnt = 0L;
        public long RXData_cnt = 0L;
        public long RXBuffer_cnt = 0L;
        public long TXSignal_cnt = 0L;
        public long TXData_cnt = 0L;
        public long TXBuffer_cnt = 0L;
    }

    private static enum L2Error {
        DLE_ERROR,
        L2_RX_OVERFLOW,
        L2_TX_OVERFLOW,
        CHSUM_ERROR,
        LENGTH_FIELD_ERROR,
        MISSING_START,
        LAST_L2_ERROR;

    }

    private static enum l2_state_t {
        L2_SYNC_STATE,
        L2_WAIT_STX_STATE,
        L2_RECV_STATE,
        L2_DLE_STATE;

    }
}

