/*
 * Decompiled with CFR 0.152.
 */
package unitTest;

import java.util.Enumeration;
import java.util.Vector;
import unitTest.Test;
import unitTest.TestCase;
import unitTest.TestResult;

public class TestSuite
implements Test {
    private String fName;
    private Vector<Test> fTests = new Vector(10);

    public static Test warning(final String message) {
        return new TestCase("warning"){

            @Override
            protected void runTest() {
                1.fail(message);
            }
        };
    }

    public TestSuite() {
    }

    public TestSuite(String name) {
        this.setName(name);
    }

    public void addTest(Test test) {
        this.fTests.addElement(test);
    }

    @Override
    public int countTestCases() {
        int count = 0;
        Enumeration<Test> e = this.tests();
        while (e.hasMoreElements()) {
            Test test = e.nextElement();
            count += test.countTestCases();
        }
        return count;
    }

    public String getName() {
        return this.fName;
    }

    @Override
    public void run(TestResult result) {
        Enumeration<Test> e = this.tests();
        while (e.hasMoreElements()) {
            if (result.shouldStop()) break;
            Test test = e.nextElement();
            this.runTest(test, result);
        }
    }

    public void runTest(Test test, TestResult result) {
        test.run(result);
    }

    public void setName(String name) {
        this.fName = name;
    }

    public Test testAt(int index) {
        return this.fTests.elementAt(index);
    }

    public int testCount() {
        return this.fTests.size();
    }

    public Enumeration<Test> tests() {
        return this.fTests.elements();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }
}

